/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.variability;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.fortiss.af3.state.model.AF3StatePackage;
import org.fortiss.af3.state.variability.InitialStatePredicate;
import org.fortiss.tooling.base.model.element.ElementPackage;
import org.fortiss.variability.analysis.IProductLineTranslation;
import org.fortiss.variability.analysis.constraint.ContainedQuantifierVariable;
import org.fortiss.variability.analysis.constraint.ExistentialQuantifier;
import org.fortiss.variability.analysis.constraint.IPreComputedFunction;
import org.fortiss.variability.analysis.constraint.IQuantifier;
import org.fortiss.variability.analysis.constraint.ProductLineConstraintBase;
import org.fortiss.variability.analysis.constraint.QuantifierVariable;
import org.fortiss.variability.model.features.configuration.VariantConfiguration;

public class SimplifiedOneInitialStateConstraint
extends ProductLineConstraintBase {
    private static final EReference REF_CONTAINED_ELEMENTS = ElementPackage.Literals.IHIERARCHIC_ELEMENT_CONTAINER__CONTAINED_ELEMENTS;
    private static final EClass STATE_CLASS = AF3StatePackage.Literals.STATE;

    public SimplifiedOneInitialStateConstraint(IProductLineTranslation translation) {
        super(translation);
    }

    public String getConstraintName() {
        return "One initial state constraint";
    }

    public String createErrorMessage(List<EObject> violatingObjects, VariantConfiguration violatingConfiguration) {
        return "The initial states are not mutually exclusive.";
    }

    public Collection<EClass> getTranslatedClasses() {
        return Arrays.asList(STATE_CLASS);
    }

    public Collection<EReference> getTranslatedReferences() {
        return Arrays.asList(REF_CONTAINED_ELEMENTS);
    }

    public QuantifierVariable[] getQuantifierVariables() {
        return new QuantifierVariable[]{new QuantifierVariable(STATE_CLASS, "s0")};
    }

    protected BoolExpr createBody() {
        final Context ctx = this.translation.getContext();
        final Expr z3S0 = this.getZ3Variable("s0");
        ExistentialQuantifier allStatesQuant = new ExistentialQuantifier(this.translation){

            public QuantifierVariable[] getQuantifierVariables() {
                return new QuantifierVariable[]{new ContainedQuantifierVariable(STATE_CLASS, "s1", STATE_CLASS, z3S0, "containedElements"), new ContainedQuantifierVariable(STATE_CLASS, "s2", STATE_CLASS, z3S0, "containedElements")};
            }

            protected BoolExpr createBody() {
                Expr z3s1 = this.getZ3Variable("s1");
                Expr z3s2 = this.getZ3Variable("s2");
                FuncDecl initialFun = this.translation.getAttributeReferenceFunctionDeclaration(STATE_CLASS, "isInitial");
                return ctx.mkAnd(new Expr[]{ctx.mkNot((Expr)ctx.mkEq(z3s1, z3s2)), (BoolExpr)ctx.mkApp(initialFun, new Expr[]{z3s1}), (BoolExpr)ctx.mkApp(initialFun, new Expr[]{z3s2})});
            }
        };
        return this.translation.translateQuantifier((IQuantifier)allStatesQuant);
    }

    public void addReferenceTypeExceptions(IProductLineTranslation translation) {
        translation.setTranslatedClassForEReferences(REF_CONTAINED_ELEMENTS, STATE_CLASS, STATE_CLASS);
    }

    public Collection<IPreComputedFunction<?, ?>> getPrecomputedFunctions() {
        return Arrays.asList(new IPreComputedFunction[]{new InitialStatePredicate()});
    }
}

