/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.state.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.simulator.ExecutableComponent;
import org.fortiss.af3.component.utils.ComponentModelElementFactory;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.terms.EOperator;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.impl.BoolConstStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.FunctionCallStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.PredefinedFunctionStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.VarStaticImpl;
import org.fortiss.af3.expression.model.types.TypesFactory;
import org.fortiss.af3.expression.model.types.TypesPackage;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.IFunction;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.af3.state.model.TransitionSegment;
import org.fortiss.af3.state.utils.StateModelElementFactory;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import test.org.fortiss.af3.component.model.ComponentTestModelBase;

public abstract class IntVarBaseOutputTestModel
extends ComponentTestModelBase {
    public static final Map<ArithOp, EOperator> eOpMap;
    public Component intVarComponent;
    public InputPort activationPort;
    public String[] inPortNames = new String[]{"activate", "addPort", "subPort", "multPort", "divPort"};
    public InputPort addPort;
    public InputPort subPort;
    public InputPort multPort;
    public InputPort divPort;
    protected EClass[] inPortTypes = new EClass[]{TypesPackage.Literals.TBOOL, TypesPackage.Literals.TINT, TypesPackage.Literals.TINT, TypesPackage.Literals.TINT, TypesPackage.Literals.TINT};
    public OutputPort outputPort;
    public StateAutomaton stateAutomaton;
    public State inactiveState;
    public State activeState;
    protected ExecutableComponent<?> executable;
    private Map<ArithOp, InputPort> portMap;
    protected List<TransitionSegment> transitions = new LinkedList<TransitionSegment>();

    static {
        HashMap<ArithOp, EOperator> map = new HashMap<ArithOp, EOperator>();
        map.put(ArithOp.ADD, EOperator.ADD);
        map.put(ArithOp.SUB, EOperator.SUBTRACT);
        map.put(ArithOp.MULT, EOperator.MULTIPLY);
        map.put(ArithOp.DIV, EOperator.DIVIDE);
        eOpMap = Collections.unmodifiableMap(map);
    }

    private void initPortMap() {
        HashMap<ArithOp, InputPort> map = new HashMap<ArithOp, InputPort>();
        map.put(ArithOp.ADD, this.addPort);
        map.put(ArithOp.SUB, this.subPort);
        map.put(ArithOp.MULT, this.multPort);
        map.put(ArithOp.DIV, this.divPort);
        this.portMap = Collections.unmodifiableMap(map);
    }

    public Map<ArithOp, InputPort> getPortMap() {
        return this.portMap;
    }

    public void setupModel() {
        super.setupModel();
        ICommandStackService.getInstance().runAsCommand((EObject)this.project, () -> this.createIntVarComponent());
    }

    private void createIntVarComponent() {
        this.intVarComponent = ComponentModelElementFactory.createComponentAndAttach((Component)this.rootComponent, (String)"IntVar", (String)"", (boolean)true);
        InputPort[] inPorts = new InputPort[this.inPortNames.length];
        int i = 0;
        while (i < this.inPortNames.length) {
            inPorts[i] = ComponentModelElementFactory.createInputPortAndAttach((Component)this.intVarComponent, (String)this.inPortNames[i], (IType)((IType)TypesFactory.eINSTANCE.create(this.inPortTypes[i])), (IExpressionTerm)NoVal.NOVAL.toITerm());
            ++i;
        }
        this.activationPort = inPorts[0];
        this.addPort = inPorts[1];
        this.subPort = inPorts[2];
        this.multPort = inPorts[3];
        this.divPort = inPorts[4];
        this.initPortMap();
        this.outputPort = ComponentModelElementFactory.createOutputPortAndAttach((Component)this.intVarComponent, (String)"Output", (IType)ExpressionModelElementFactory.intType(), (IExpressionTerm)NoVal.NOVAL.toITerm());
        this.createAutomaton();
    }

    protected void createAutomaton() {
        this.createStates();
        this.createVariables();
        this.createTransitions();
    }

    protected void createStates() {
        this.stateAutomaton = StateModelElementFactory.createStateAutomaton("RootState");
        this.intVarComponent.getSpecifications().add((Object)this.stateAutomaton);
        State rootState = this.stateAutomaton.getRootState();
        this.inactiveState = StateModelElementFactory.createState(rootState, "InactiveState", "", true);
        this.activeState = StateModelElementFactory.createState(rootState, "ActiveState", "", false);
    }

    protected void createVariables() {
        StateModelElementFactory.createDataStateVariable(this.stateAutomaton, "var", (IType)ExpressionModelElementFactory.intType(), (IExpressionTerm)ExpressionModelElementFactory.intConst((int)0));
    }

    public void printTransitions() {
        System.out.println(StringUtils.concat(this.transitions, (String)"\n"));
    }

    protected void createTransitions() {
        State rootState = this.stateAutomaton.getRootState();
        TransitionSegment activate = StateModelElementFactory.createTransitionSegment(rootState, this.inactiveState, this.activeState, "activate", "");
        StateModelElementFactory.createGuard(activate, (IExpressionTerm)FunctionCallStaticImpl.create((IFunction)PredefinedFunctionStaticImpl.create((EOperator)EOperator.EQUAL), (IExpressionTerm[])new IExpressionTerm[]{VarStaticImpl.create((String)this.activationPort.getName()), BoolConstStaticImpl.create((boolean)true)}));
        TransitionSegment deactivate = StateModelElementFactory.createTransitionSegment(rootState, this.activeState, this.inactiveState, "deactivate", "");
        StateModelElementFactory.createGuard(deactivate, (IExpressionTerm)FunctionCallStaticImpl.create((IFunction)PredefinedFunctionStaticImpl.create((EOperator)EOperator.EQUAL), (IExpressionTerm[])new IExpressionTerm[]{VarStaticImpl.create((String)this.activationPort.getName()), BoolConstStaticImpl.create((boolean)false)}));
        TransitionSegment add = this.createArithOpTransition(ArithOp.ADD, "add");
        TransitionSegment sub = this.createArithOpTransition(ArithOp.SUB, "sub");
        TransitionSegment mult = this.createArithOpTransition(ArithOp.MULT, "mult");
        TransitionSegment div = this.createArithOpTransition(ArithOp.DIV, "div");
        this.transitions.addAll(Arrays.asList(activate, deactivate, add, sub, mult, div));
    }

    protected abstract TransitionSegment createArithOpTransition(ArithOp var1, String var2);

    public static enum ArithOp {
        ADD,
        SUB,
        MULT,
        DIV;


        public int eval(int a, int b) {
            switch (this) {
                case ADD: {
                    return a + b;
                }
                case SUB: {
                    return a - b;
                }
                case MULT: {
                    return a * b;
                }
                case DIV: {
                    return a / b;
                }
            }
            return 0;
        }
    }
}

