/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.state.simulator;

import org.fortiss.af3.expression.language.evaluation.BoolValue;
import org.fortiss.af3.expression.language.evaluation.IntValue;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.model.execution.ExecutionConfiguration;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.af3.project.utils.ProjectUtils;
import org.fortiss.af3.state.simulator.ExecutableStateAutomatonSpecification;
import org.junit.Assert;
import org.junit.Test;
import test.org.fortiss.af3.component.simulator.ComponentSimulatorTestBase;
import test.org.fortiss.af3.state.model.IntVarBaseOutputTestModel;

public abstract class SimulatorTest_IntVarBaseOutput<T extends IntVarBaseOutputTestModel>
extends ComponentSimulatorTestBase<T, ExecutableStateAutomatonSpecification> {
    public SimulatorTest_IntVarBaseOutput(T testModel) {
        super(testModel);
    }

    @Test
    public void testModel() {
        ExecutionConfiguration executionConfiguration = ((IntVarBaseOutputTestModel)this.testModel).executionConfiguration;
        ((Object)((Object)((IntVarBaseOutputTestModel)this.testModel))).getClass();
        Assert.assertEquals((Object)executionConfiguration, (Object)ProjectUtils.findExecutionConfiguration((int)43, (FileProject)((IntVarBaseOutputTestModel)this.testModel).project));
        Assert.assertEquals((Object)((IntVarBaseOutputTestModel)this.testModel).stateAutomaton, (Object)((ExecutableStateAutomatonSpecification)this.observedSimulator).getSpecification());
        Assert.assertEquals((Object)((IntVarBaseOutputTestModel)this.testModel).intVarComponent, (Object)((ExecutableStateAutomatonSpecification)this.observedSimulator).getModelElement());
    }

    @Test
    public void testInitializeSimulator() {
        Assert.assertEquals((String)"Initialization: initial state.", (Object)((ExecutableStateAutomatonSpecification)this.observedSimulator).getCurrentState(), (Object)((IntVarBaseOutputTestModel)this.testModel).stateAutomaton.getInitialState());
        Assert.assertEquals((String)"After initialization the output port should be NoVal.", (Object)NoVal.NOVAL, (Object)((ExecutableStateAutomatonSpecification)this.observedSimulator).getCurrentOutputValue(((IntVarBaseOutputTestModel)this.testModel).outputPort));
    }

    protected void assertActivate() {
        ((ExecutableStateAutomatonSpecification)this.observedSimulator).setNextInputValue(((IntVarBaseOutputTestModel)this.testModel).activationPort, (Term)BoolValue.TRUE);
        this.performStepWithClear();
        Assert.assertEquals((String)"Current state should be \"active\"", (Object)((IntVarBaseOutputTestModel)this.testModel).activeState, (Object)((ExecutableStateAutomatonSpecification)this.observedSimulator).getCurrentState());
    }

    protected void assertDeactivate() {
        ((ExecutableStateAutomatonSpecification)this.observedSimulator).setNextInputValue(((IntVarBaseOutputTestModel)this.testModel).activationPort, (Term)BoolValue.FALSE);
        this.performStepWithClear();
        Assert.assertEquals((String)"Current state should be \"inactive\"", (Object)((IntVarBaseOutputTestModel)this.testModel).inactiveState, (Object)((ExecutableStateAutomatonSpecification)this.observedSimulator).getCurrentState());
    }

    protected void assertOutput(int expected) {
        Assert.assertTrue((String)"Output should be not empty", (!NoVal.NOVAL.equals((Object)((ExecutableStateAutomatonSpecification)this.observedSimulator).getInternalOutputValue(((IntVarBaseOutputTestModel)this.testModel).outputPort)) ? 1 : 0) != 0);
        Assert.assertEquals((String)("Output should be " + expected), (Object)new IntValue(Integer.valueOf(expected)), (Object)((ExecutableStateAutomatonSpecification)this.observedSimulator).getInternalOutputValue(((IntVarBaseOutputTestModel)this.testModel).outputPort));
    }

    protected void performStepWithClear() {
        this.topSimulator.performStep();
    }

    protected abstract int assertArithOpRunUntilOutput(IntVarBaseOutputTestModel.ArithOp var1, int var2, int var3);

    protected int assertAddRunUntilOutput(int v, int lastValue) {
        return this.assertArithOpRunUntilOutput(IntVarBaseOutputTestModel.ArithOp.ADD, v, lastValue);
    }

    protected int assertSubRunUntilOutput(int v, int lastValue) {
        return this.assertArithOpRunUntilOutput(IntVarBaseOutputTestModel.ArithOp.SUB, v, lastValue);
    }

    protected int assertMultRunUntilOutput(int v, int lastValue) {
        return this.assertArithOpRunUntilOutput(IntVarBaseOutputTestModel.ArithOp.MULT, v, lastValue);
    }

    protected int assertDivRunUntilOutput(int v, int lastValue) {
        return this.assertArithOpRunUntilOutput(IntVarBaseOutputTestModel.ArithOp.DIV, v, lastValue);
    }
}

