/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.behavior;

import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.AF3ComponentActivator;
import org.fortiss.af3.component.model.behavior.common.Action;
import org.fortiss.af3.component.model.behavior.common.CommonFactory;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.impl.VarStaticImpl;
import org.fortiss.af3.expression.ui.databinding.convert.StringToIExpressionTermConverter;
import org.fortiss.af3.project.ui.utils.ParsingUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class StringToActionsConverter
extends Converter {
    private final StringToIExpressionTermConverter singleStringConverter;

    public StringToActionsConverter(EObject ctx) {
        super(String.class, EList.class);
        this.singleStringConverter = new StringToIExpressionTermConverter(ctx);
    }

    public Object convert(Object fromObject) {
        BasicEList actions = new BasicEList();
        String[] stringArray = ParsingUtils.splitString((String)((String)fromObject), (String)";", (boolean)true);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            Action action = CommonFactory.eINSTANCE.createAction();
            action.setStringRepresentation(str);
            try {
                int idx = str.indexOf(61);
                if (idx == -1) {
                    return new RuntimeException("Missing '=' in action term.");
                }
                String varStr = str.substring(0, idx);
                String termStr = str.length() > idx ? str.substring(idx + 1, str.length()) : "";
                IExpressionTerm lhs = this.singleStringConverter.convert((Object)varStr);
                action.setVariable(VarStaticImpl.create((IExpressionTerm)lhs));
                IExpressionTerm rhs = this.singleStringConverter.convert((Object)termStr);
                action.setValue(rhs);
                actions.add((Object)action);
            }
            catch (Exception e) {
                LoggingUtils.error((Plugin)AF3ComponentActivator.getDefault(), (String)"Conversion problems not caught by the validator!", (Throwable)e);
            }
            ++n2;
        }
        return actions;
    }
}

