/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.behavior;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.language.ParseException;
import org.fortiss.af3.project.services.ITypeSystemService;
import org.fortiss.af3.project.typesystem.ITypeSystemCompiler;
import org.fortiss.af3.project.ui.utils.ParsingUtils;

public class StringToActionsValidator
implements IValidator {
    private final EObject editedObject;

    public StringToActionsValidator(EObject editedObject) {
        this.editedObject = editedObject;
    }

    public IStatus validate(Object value) {
        String[] stringArray = ParsingUtils.splitString((String)((String)value), (String)";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            ITypeSystemCompiler compiler = ITypeSystemService.INSTANCE.getHandler(this.editedObject).getTypeSystemCompiler();
            try {
                int idx = str.indexOf(61);
                if (idx == -1) {
                    return ValidationStatus.cancel((String)"Missing '=' in action term.");
                }
                String varStr = str.substring(0, idx);
                compiler.compileTerm(varStr, this.editedObject);
                String termStr = str.length() > idx ? str.substring(idx + 1, str.length()) : "";
                compiler.compileTerm(termStr, this.editedObject);
            }
            catch (ParseException e) {
                return ValidationStatus.cancel((String)e.getMessage());
            }
            ++n2;
        }
        return ValidationStatus.ok();
    }
}

