/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.commands;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.utils.IComponentArchitectureTransformation;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.base.layout.KielerAutoLayouter;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.ui.javafx.control.treetableview.ModelElementTreeViewer;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeItemBase;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuMultiSelectionContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public abstract class ComponentArchitectureTransformationMenuBase<A extends IProjectRootElement & IHierarchicElement, AE extends AllocationTable>
implements IContextMenuMultiSelectionContributor {
    private IComponentArchitectureTransformation<A> compTrans;
    private Class<AE> entityAllocationTableType;

    protected ComponentArchitectureTransformationMenuBase(IComponentArchitectureTransformation<A> compTrans, Class<AE> entityAllocationTableType) {
        this.compTrans = compTrans;
        this.entityAllocationTableType = entityAllocationTableType;
    }

    private String getMenuLabel() {
        return "Generate " + this.getGeneratedArchitectureTypeName();
    }

    protected abstract ImageDescriptor getActionIcon();

    protected abstract String getGeneratedArchitectureTypeName();

    public List<IContributionItem> getContributedItems(List<EObject> selection, ContextMenuContextProvider contextProvider) {
        if (selection == null) {
            return Collections.emptyList();
        }
        EList cas = EcoreUtils.pickInstanceOf(ComponentArchitecture.class, selection);
        EList comps = EcoreUtils.pickInstanceOf(Component.class, selection);
        if (cas.size() != 1 || comps.size() != selection.size() - 1) {
            return Collections.emptyList();
        }
        ComponentArchitecture ca = (ComponentArchitecture)cas.get(0);
        for (Component c : comps) {
            EObject obj = c.eContainer();
            while (obj != null) {
                if (obj instanceof ComponentArchitecture && obj != ca || comps.contains(obj)) {
                    return Collections.emptyList();
                }
                obj = obj.eContainer();
            }
        }
        LaunchTransformComponentArchitectureAction action = new LaunchTransformComponentArchitectureAction(ca, (List<Component>)comps);
        return Arrays.asList(new ActionContributionItem((IAction)action));
    }

    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        return this.getContributedItems(Arrays.asList(selection), contextProvider);
    }

    public String getMenuSectionID() {
        return null;
    }

    private class AllocationTableSelectionCollectionDialog {
        private final Stage dialogStage = new Stage();
        private final TreeView<INamedElement> treeView;
        private final Button addButton;
        private final Label addButtonLabel;
        boolean isCreationConfirmed = false;

        public AllocationTableSelectionCollectionDialog(FileProject fileProject) {
            this.dialogStage.setTitle("Select allocation table collection");
            this.dialogStage.initModality(Modality.APPLICATION_MODAL);
            this.dialogStage.setAlwaysOnTop(true);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            shell.addListener(19, e -> this.dialogStage.hide());
            shell.addListener(20, e -> this.dialogStage.show());
            String archName = ComponentArchitectureTransformationMenuBase.this.getGeneratedArchitectureTypeName();
            String allocName = "Component \u2192 " + archName;
            Label labelInstructions = new Label("Select the allocation table collection into which you would like to integrate the generated " + allocName + ". You can also create a new allocation table collection, or cancel the generation altogether.");
            labelInstructions.setWrapText(true);
            labelInstructions.setMinHeight(Double.NEGATIVE_INFINITY);
            this.treeView = new TreeView();
            this.initTreeViewer((INamedElement)fileProject, archName, allocName);
            this.addButton = new Button("Add");
            this.addButton.setMinWidth(75.0);
            this.addButton.setDisable(true);
            this.addButton.setOnAction(e -> {
                this.isCreationConfirmed = true;
                this.dialogStage.close();
            });
            this.addButtonLabel = new Label("");
            this.addButtonLabel.setWrapText(true);
            this.addButtonLabel.setMinHeight(40.0);
            this.addButtonLabel.setMaxWidth(400.0);
            Button newButton = new Button("New");
            newButton.setMinWidth(75.0);
            newButton.setOnAction(e -> {
                this.isCreationConfirmed = true;
                this.treeView.getSelectionModel().clearSelection();
                this.dialogStage.close();
            });
            Button cancelButton = new Button("Cancel");
            cancelButton.setMinWidth(75.0);
            cancelButton.setOnAction(e -> this.dialogStage.close());
            Region spacer = new Region();
            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            HBox buttons = new HBox(10.0, new Node[]{this.addButtonLabel, spacer, this.addButton, newButton, cancelButton});
            buttons.setAlignment(Pos.CENTER);
            buttons.setPadding(new Insets(10.0));
            VBox layout = new VBox(10.0, new Node[]{labelInstructions, this.treeView, buttons});
            VBox.setVgrow((Node)labelInstructions, (Priority)Priority.NEVER);
            VBox.setVgrow(this.treeView, (Priority)Priority.ALWAYS);
            layout.setPadding(new Insets(10.0));
            layout.setSpacing(10.0);
            Scene scene = new Scene((Parent)layout, 700.0, 400.0);
            this.dialogStage.setScene(scene);
            this.dialogStage.setResizable(false);
        }

        private void initTreeViewer(INamedElement root, final String archName, final String allocName) {
            final ModelElementTreeViewer meTreeViewer = new ModelElementTreeViewer(this.treeView, root, false, 1, (DynamicTreeContentProviderBase)new DynamicTreeContentProviderBase<INamedElement>(){

                protected Collection<? extends INamedElement> getChildren(INamedElement parent) {
                    IAllocationService as = IAllocationService.getInstance();
                    if (parent instanceof FileProject) {
                        FileProject fp = (FileProject)parent;
                        return EcoreUtils.pickInstanceOf(AllocationTableCollection.class, (List)fp.getRootElements());
                    }
                    if (parent instanceof AllocationTableCollection) {
                        AllocationTableCollection atc = (AllocationTableCollection)parent;
                        return atc.getAllocationTables().stream().filter(t -> !as.isAllocationTableInternal(t.getClass())).collect(Collectors.toList());
                    }
                    return Collections.emptyList();
                }
            });
            this.treeView.addEventHandler(InputEvent.ANY, (EventHandler)new EventHandler<InputEvent>(){

                public void handle(InputEvent event) {
                    ObservableList atcs;
                    int i;
                    EventType eventType = event.getEventType();
                    if (eventType != MouseEvent.MOUSE_CLICKED && eventType != KeyEvent.KEY_PRESSED) {
                        return;
                    }
                    AllocationTableSelectionCollectionDialog.this.addButton.setText("Add");
                    AllocationTableSelectionCollectionDialog.this.addButtonLabel.setText("");
                    AllocationTableCollection atc = AllocationTableSelectionCollectionDialog.this.getSelectedAllocationTableCollection();
                    if (atc == null) {
                        AllocationTableSelectionCollectionDialog.this.addButton.setDisable(true);
                        return;
                    }
                    DynamicTreeItemBase atcTreeItem = meTreeViewer.findItem((INamedElement)atc);
                    if (eventType == KeyEvent.KEY_PRESSED && ((KeyEvent)event).getCode() == KeyCode.DOWN && (i = (atcs = AllocationTableSelectionCollectionDialog.this.treeView.getRoot().getChildren()).indexOf((Object)atcTreeItem)) < atcs.size() - 1) {
                        atcTreeItem = (TreeItem)atcs.get(i + 1);
                        INamedElement nextElem = (INamedElement)atcTreeItem.getValue();
                        if (!(nextElem instanceof AllocationTableCollection)) {
                            return;
                        }
                        atc = (AllocationTableCollection)nextElem;
                    }
                    AllocationTableSelectionCollectionDialog.this.treeView.getSelectionModel().select((Object)atcTreeItem);
                    AllocationTableSelectionCollectionDialog.this.addButtonLabel.setText("The generated " + allocName + " is not compatible with the selected collection.");
                    for (AllocationTable at : atc.getAllocationTables()) {
                        if (!((AllocationTableSelectionCollectionDialog)AllocationTableSelectionCollectionDialog.this).ComponentArchitectureTransformationMenuBase.this.entityAllocationTableType.isAssignableFrom(at.getClass())) continue;
                        AllocationTableSelectionCollectionDialog.this.addButton.setDisable(false);
                        AllocationTableSelectionCollectionDialog.this.addButton.setText("Overwrite");
                        AllocationTableSelectionCollectionDialog.this.addButtonLabel.setText("The selected " + allocName + " and the existing " + archName + " will be overwritten.");
                        return;
                    }
                    EClass eClass = EcoreUtils.getEClassForClass(((AllocationTableSelectionCollectionDialog)AllocationTableSelectionCollectionDialog.this).ComponentArchitectureTransformationMenuBase.this.entityAllocationTableType);
                    EObject at = eClass.getEPackage().getEFactoryInstance().create(eClass);
                    IElementCompositorService cs = IElementCompositorService.getInstance();
                    boolean isCompatible = cs.canCompose((EObject)atc, at, null);
                    AllocationTableSelectionCollectionDialog.this.addButton.setDisable(!isCompatible);
                    if (isCompatible) {
                        AllocationTableSelectionCollectionDialog.this.addButtonLabel.setText("A " + allocName + " will be added to selected collection, and a new " + archName + " will be created.");
                    }
                }
            });
        }

        public AllocationTableCollection getSelectedAllocationTableCollection() {
            TreeItem selectedItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
            return selectedItem != null ? (AllocationTableCollection)KernelModelElementUtils.getParentElement((EObject)((EObject)selectedItem.getValue()), AllocationTableCollection.class, (boolean)true) : null;
        }

        public boolean confirmAllocationTableCollection() {
            this.dialogStage.showAndWait();
            return this.isCreationConfirmed;
        }
    }

    protected class LaunchTransformComponentArchitectureAction
    extends Action {
        private final ComponentArchitecture ca;
        private final List<Component> comps;

        public LaunchTransformComponentArchitectureAction(ComponentArchitecture ca, List<Component> comps) {
            super(ComponentArchitectureTransformationMenuBase.this.getMenuLabel(), ComponentArchitectureTransformationMenuBase.this.getActionIcon());
            this.ca = ca;
            this.comps = comps;
        }

        public void run() {
            FileProject fileProject = (FileProject)EcoreUtils.getFirstParentWithType((EObject)this.ca, FileProject.class);
            ITopLevelElement topLevelElement = IPersistencyService.getInstance().getTopLevelElementFor((EObject)fileProject);
            topLevelElement.runAsCommand(() -> {
                AllocationTable caAlloc;
                IElementCompositorService cs = IElementCompositorService.getInstance();
                AllocationTableSelectionCollectionDialog diag = new AllocationTableSelectionCollectionDialog(fileProject);
                if (!diag.confirmAllocationTableCollection()) {
                    return;
                }
                AllocationTableCollection atc = diag.getSelectedAllocationTableCollection();
                IHierarchicElement arch = ComponentArchitectureTransformationMenuBase.this.compTrans.transform(this.ca.getTopComponent(), this.comps, atc);
                cs.compose((EObject)fileProject, (EObject)arch, null);
                KielerAutoLayouter al = new KielerAutoLayouter();
                al.performAutoLayout(arch);
                if (atc != null && (caAlloc = atc.getAllocationTable(ComponentArchitectureTransformationMenuBase.this.entityAllocationTableType)) != null) {
                    cs.decompose((EObject)caAlloc.getTargetView());
                    cs.decompose((EObject)caAlloc);
                }
            });
        }
    }
}

