/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.utils.ComponentModelElementFactory;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class PackUnpackComponents {
    public static List<Component> unpack(List<Component> components) {
        HashSet<Component> targetComponents = new HashSet<Component>();
        for (Component component : components) {
            Component targetComponent = component.getParentComponent();
            targetComponents.add(targetComponent);
            PackUnpackComponents.createInputExternalPort(component, targetComponent);
            PackUnpackComponents.createOutputExternalPort(component, targetComponent);
            EList subComponents = component.getSubComponents();
            for (Component subComponent : subComponents) {
                targetComponent.getContainedElements().add((Object)subComponent);
                PackUnpackComponents.processInboundChannelsUnpack(subComponent, targetComponent, (List<Component>)subComponents);
                PackUnpackComponents.processOutboundChannelsUnpack(subComponent, targetComponent, (List<Component>)subComponents);
            }
            if (subComponents.isEmpty()) continue;
            IElementCompositorService cs = IElementCompositorService.getInstance();
            cs.decompose((EObject)component);
        }
        return new ArrayList<Component>(targetComponents);
    }

    private static void processInboundChannelsUnpack(Component component, Component targetComponent, List<Component> components) {
        for (InputPort inputPort : component.getInputPorts()) {
            ArrayList<Channel> externChannels = new ArrayList<Channel>();
            for (Channel channel : inputPort.getIncomingChannels()) {
                if (components.contains(channel.getSource().getComponent())) continue;
                externChannels.add(channel);
            }
            if (!externChannels.isEmpty()) continue;
            for (Channel channel : inputPort.getIncomingChannels()) {
                targetComponent.getConnections().add((Object)channel);
            }
        }
    }

    private static void processOutboundChannelsUnpack(Component component, Component targetComponent, List<Component> components) {
        for (OutputPort outputPort : component.getOutputPorts()) {
            ArrayList<Channel> externChannels = new ArrayList<Channel>();
            for (Channel channel : outputPort.getOutgoingChannels()) {
                if (components.contains(channel.getTarget().getComponent())) continue;
                externChannels.add(channel);
            }
            if (!externChannels.isEmpty()) continue;
            for (Channel channel : outputPort.getOutgoingChannels()) {
                targetComponent.getConnections().add((Object)channel);
            }
        }
    }

    private static void removePorts(List<Port> portsToRemove, List<Port> componentPorts, List<Port> targetPorts) {
        ArrayList<String> componentPortsString = new ArrayList<String>();
        ArrayList<String> targetPortsString = new ArrayList<String>();
        ArrayList<String> portsToRemoveString = new ArrayList<String>();
        for (Port port : componentPorts) {
            componentPortsString.add(port.getName());
        }
        for (Port port : portsToRemove) {
            portsToRemoveString.add(port.getName());
        }
        for (Port port : targetPorts) {
            targetPortsString.add(port.getName());
        }
        for (String string : portsToRemoveString) {
            int index;
            if (targetPortsString.contains(string)) {
                index = targetPortsString.indexOf(string);
                targetPortsString.set(index, " ");
                IElementCompositorService.getInstance().decompose((EObject)targetPorts.get(index));
                index = targetPortsString.indexOf(string);
                if (index >= 0) {
                    targetPortsString.set(index, " ");
                    IElementCompositorService.getInstance().decompose((EObject)targetPorts.get(index));
                }
            }
            if (!componentPortsString.contains(string)) continue;
            index = componentPortsString.indexOf(string);
            componentPortsString.set(index, " ");
            IElementCompositorService.getInstance().decompose((EObject)componentPorts.get(index));
            index = componentPortsString.indexOf(string);
            if (index < 0) continue;
            componentPortsString.set(index, " ");
            IElementCompositorService.getInstance().decompose((EObject)componentPorts.get(index));
        }
    }

    private static void createInputExternalPort(Component component, Component targetComponent) {
        Port source = null;
        Port target = null;
        Port midTarget = null;
        EList componentInputPorts = component.getInputPorts();
        ArrayList<Port> portsToRemove = new ArrayList<Port>();
        for (InputPort inputPort : componentInputPorts) {
            for (Channel channel : inputPort.getOutgoingChannels()) {
                target = channel.getTarget();
                for (Channel midChannel : inputPort.getIncomingChannels()) {
                    midTarget = midChannel.getTarget();
                    source = midChannel.getSource();
                    if (midTarget.getName().equals(source.getName())) continue;
                    portsToRemove.add(midTarget);
                }
                if (midTarget == null) {
                    InputPort input = ComponentModelElementFactory.createInputPortAndAttach((Component)targetComponent, (String)inputPort.getName(), (IType)((IType)EcoreUtils.copy((EObject)inputPort.getVariableType())), (IExpressionTerm)((IExpressionTerm)EcoreUtils.copy((EObject)inputPort.getInitialValue())));
                    ComponentModelElementFactory.createChannelAndAttach((Component)targetComponent, (String)channel.getName(), (Port)input, (Port)channel.getTarget());
                    targetComponent.getConnections().add((Object)channel);
                    continue;
                }
                if (target == null || source == null) continue;
                for (Channel incChannel : inputPort.getIncomingChannels()) {
                    ComponentModelElementFactory.createChannelAndAttach((Component)targetComponent, (String)incChannel.getName(), (Port)incChannel.getSource(), (Port)target);
                    targetComponent.getConnections().add((Object)incChannel);
                }
            }
        }
        EList targetInputPorts = targetComponent.getInputPorts();
        ArrayList<Port> componentPorts = new ArrayList<Port>();
        int i = 0;
        while (i < componentInputPorts.size()) {
            componentPorts.add((Port)componentInputPorts.get(i));
            ++i;
        }
        ArrayList<Port> targetPorts = new ArrayList<Port>();
        int i2 = 0;
        while (i2 < targetInputPorts.size()) {
            targetPorts.add((Port)targetInputPorts.get(i2));
            ++i2;
        }
        PackUnpackComponents.removePorts(portsToRemove, componentPorts, targetPorts);
    }

    private static void createOutputExternalPort(Component component, Component targetComponent) {
        Port source = null;
        Port midSource = null;
        Port target = null;
        EList componentOutputPorts = component.getOutputPorts();
        ArrayList<Port> portsToRemove = new ArrayList<Port>();
        for (OutputPort outputPort : componentOutputPorts) {
            for (Channel channel : outputPort.getIncomingChannels()) {
                source = channel.getSource();
                for (Channel midChannel : outputPort.getOutgoingChannels()) {
                    midSource = midChannel.getSource();
                    target = midChannel.getTarget();
                    if (midSource.getName().equals(target.getName())) continue;
                    portsToRemove.add(midSource);
                }
                if (midSource == null) {
                    OutputPort output = ComponentModelElementFactory.createOutputPortAndAttach((Component)targetComponent, (String)outputPort.getName(), (IType)((IType)EcoreUtils.copy((EObject)outputPort.getVariableType())), (IExpressionTerm)((IExpressionTerm)EcoreUtils.copy((EObject)outputPort.getInitialValue())));
                    ComponentModelElementFactory.createChannelAndAttach((Component)targetComponent, (String)channel.getName(), (Port)channel.getSource(), (Port)output);
                    targetComponent.getConnections().add((Object)channel);
                    continue;
                }
                if (source == null || target == null) continue;
                for (Channel outChannel : outputPort.getOutgoingChannels()) {
                    ComponentModelElementFactory.createChannelAndAttach((Component)targetComponent, (String)outChannel.getName(), (Port)source, (Port)outChannel.getTarget());
                    targetComponent.getConnections().add((Object)outChannel);
                }
            }
        }
        EList targetOutputPorts = targetComponent.getOutputPorts();
        ArrayList<Port> componentPorts = new ArrayList<Port>();
        int i = 0;
        while (i < componentOutputPorts.size()) {
            componentPorts.add((Port)componentOutputPorts.get(i));
            ++i;
        }
        ArrayList<Port> targetPorts = new ArrayList<Port>();
        int i2 = 0;
        while (i2 < targetOutputPorts.size()) {
            targetPorts.add((Port)targetOutputPorts.get(i2));
            ++i2;
        }
        PackUnpackComponents.removePorts(portsToRemove, componentPorts, targetPorts);
    }

    public static Component pack(List<Component> components) {
        if (components.isEmpty()) {
            return null;
        }
        Component newComponent = PackUnpackComponents.createPackTargetComponent(components);
        if (newComponent == null) {
            return null;
        }
        Component parentComponent = newComponent.getParentComponent();
        for (Component component : components) {
            newComponent.getContainedElements().add((Object)component);
            PackUnpackComponents.processInboundChannelsPack(component, newComponent, parentComponent, components);
            PackUnpackComponents.processOutboundChannelsPack(component, newComponent, parentComponent, components);
        }
        UniqueIDUtils.fixMissingIDs((EObject)parentComponent, (EObject)parentComponent);
        return newComponent;
    }

    private static Component createPackTargetComponent(List<Component> components) {
        Component refComp = components.get(0);
        for (Component component : components) {
            if (component.getParentComponent() == refComp.getParentComponent() || component.getCausalitySpecification() == refComp.getCausalitySpecification()) continue;
            return null;
        }
        Component parentComp = refComp.getParentComponent();
        boolean causalityValue = refComp.getCausalitySpecification().isStronglyCausal();
        Component newComp = ComponentModelElementFactory.createComponentAndAttach((Component)parentComp, (String)"New Component", (boolean)causalityValue);
        UniqueIDUtils.prepareUniqueID((EObject)newComp, (EObject)parentComp);
        parentComp.getContainedElements().add((Object)newComp);
        return newComp;
    }

    private static void processInboundChannelsPack(Component component, Component targetComponent, Component channelOwnerComp, List<Component> components) {
        for (InputPort inputPort : component.getInputPorts()) {
            ArrayList<Channel> externChannels = new ArrayList<Channel>();
            for (Channel channel : inputPort.getIncomingChannels()) {
                if (components.contains(channel.getSource().getComponent())) continue;
                externChannels.add(channel);
            }
            if (externChannels.isEmpty()) {
                for (Channel channel : inputPort.getIncomingChannels()) {
                    targetComponent.getConnections().add((Object)channel);
                }
                continue;
            }
            InputPort input = ComponentModelElementFactory.createInputPortAndAttach((Component)targetComponent, (String)inputPort.getName(), (IType)((IType)EcoreUtils.copy((EObject)inputPort.getVariableType())), (IExpressionTerm)((IExpressionTerm)EcoreUtils.copy((EObject)inputPort.getInitialValue())));
            for (Channel channel : inputPort.getIncomingChannels()) {
                if (externChannels.contains(channel)) {
                    ComponentModelElementFactory.createChannelAndAttach((Component)channelOwnerComp, (String)channel.getName(), (Port)channel.getSource(), (Port)input);
                    targetComponent.getConnections().add((Object)channel);
                    channel.setSource((IConnector)input);
                    continue;
                }
                targetComponent.getConnections().add((Object)channel);
            }
        }
    }

    private static void processOutboundChannelsPack(Component component, Component targetComponent, Component channelOwnerComp, List<Component> components) {
        for (OutputPort outputPort : component.getOutputPorts()) {
            ArrayList<Channel> externChannels = new ArrayList<Channel>();
            for (Channel channel : outputPort.getOutgoingChannels()) {
                if (components.contains(channel.getTarget().getComponent())) continue;
                externChannels.add(channel);
            }
            if (externChannels.isEmpty()) {
                for (Channel channel : outputPort.getOutgoingChannels()) {
                    targetComponent.getConnections().add((Object)channel);
                }
                continue;
            }
            OutputPort output = ComponentModelElementFactory.createOutputPortAndAttach((Component)targetComponent, (String)outputPort.getName(), (IType)((IType)EcoreUtils.copy((EObject)outputPort.getVariableType())), (IExpressionTerm)((IExpressionTerm)EcoreUtils.copy((EObject)outputPort.getInitialValue())));
            for (Channel channel : outputPort.getOutgoingChannels()) {
                if (externChannels.contains(channel)) {
                    ComponentModelElementFactory.createChannelAndAttach((Component)channelOwnerComp, (String)channel.getName(), (Port)output, (Port)channel.getTarget());
                    targetComponent.getConnections().add((Object)channel);
                    channel.setTarget((IConnector)output);
                    continue;
                }
                targetComponent.getConnections().add((Object)channel);
            }
        }
    }
}

