/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.editor.code;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.ISourceViewer;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.ui.utils.CodeUtils;
import org.fortiss.af3.component.ui.utils.ComponentFieldAssistUtils;
import org.fortiss.af3.expression.ui.utils.ExpressionFieldAssistUtils;
import org.fortiss.tooling.base.ui.editor.SourceEditorBase;
import org.fortiss.tooling.base.ui.editor.SourceEditorConfigurationBase;
import org.fortiss.tooling.base.ui.fieldassist.FieldAssistImageRegistry;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public abstract class CodeEditorConfigurationBase<T extends EObject>
extends SourceEditorConfigurationBase<T> {
    public CodeEditorConfigurationBase(SourceEditorBase<T> editor) {
        super(editor);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        IContentAssistProcessor proc = new IContentAssistProcessor(){
            private final String PROPOSAL_AUTO_ACTIVIATION_LETTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_/";

            public String getErrorMessage() {
                return null;
            }

            public IContextInformationValidator getContextInformationValidator() {
                return null;
            }

            public char[] getContextInformationAutoActivationCharacters() {
                return null;
            }

            public char[] getCompletionProposalAutoActivationCharacters() {
                return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_/".toCharArray();
            }

            public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
                return null;
            }

            public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
                ArrayList<CompletionProposal> proposalList = new ArrayList<CompletionProposal>();
                IRegion currentWordRegion = CodeUtils.findWord(viewer.getDocument(), documentOffset - 1);
                if (currentWordRegion != null) {
                    try {
                        String currentWord = viewer.getDocument().get(currentWordRegion.getOffset(), currentWordRegion.getLength());
                        Component associatedComponent = CodeEditorConfigurationBase.this.getAssociatedComponent();
                        ArrayList<String> prop = ComponentFieldAssistUtils.getInputPortNames(associatedComponent);
                        prop.addAll(ComponentFieldAssistUtils.getOutputPortNames(associatedComponent));
                        prop.addAll(ExpressionFieldAssistUtils.getFunctions((EObject)CodeEditorConfigurationBase.this.editor.getEditedObject()));
                        prop.addAll(ExpressionFieldAssistUtils.getAllConstructors((EObject)CodeEditorConfigurationBase.this.editor.getEditedObject(), (boolean)true));
                        prop.addAll(ExpressionFieldAssistUtils.getPrimitiveValues());
                        prop.addAll(ExpressionFieldAssistUtils.getUsefulExpressions());
                        prop.add("/* Multi-line Comment */");
                        for (String proposal : prop) {
                            if (!proposal.toLowerCase().startsWith(currentWord.toLowerCase())) continue;
                            proposalList.add(new CompletionProposal(proposal, currentWordRegion.getOffset(), currentWordRegion.getLength(), proposal.length(), FieldAssistImageRegistry.getIcon((String)proposal), null, null, null));
                        }
                        return proposalList.toArray(new ICompletionProposal[0]);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        };
        assistant.setContentAssistProcessor(proc, "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        return assistant;
    }

    protected List<WordRule> getCommonRules() {
        ArrayList<WordRule> rules = new ArrayList<WordRule>();
        WordRule portsRule = new WordRule(this.detector);
        rules.add(portsRule);
        WordRule dataelementsRule = new WordRule(this.detector);
        rules.add(dataelementsRule);
        Token portToken = new Token((Object)new TextAttribute(null, null, 1));
        Token dataElementToken = new Token((Object)new TextAttribute(this.DARK_BLUE, null, 2));
        Component associatedComponent = this.getAssociatedComponent();
        ArrayList<String> ports = ComponentFieldAssistUtils.getInputPortNames(associatedComponent);
        ports.addAll(ComponentFieldAssistUtils.getOutputPortNames(associatedComponent));
        this.addWordsToRule(ports, portsRule, (IToken)portToken);
        ArrayList dataelements = ExpressionFieldAssistUtils.getFunctions((EObject)this.editor.getEditedObject());
        dataelements.addAll(ExpressionFieldAssistUtils.getAllConstructorsWithoutBrackets((EObject)this.editor.getEditedObject(), (boolean)false));
        this.addWordsToRule(dataelements, dataelementsRule, (IToken)dataElementToken);
        return rules;
    }

    private Component getAssociatedComponent() {
        return (Component)EcoreUtils.getFirstParentWithType((EObject)this.editor.getEditedObject(), Component.class);
    }
}

