/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.editor.datastate;

import org.conqat.ide.commons.ui.selection.SelectionUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.model.behavior.common.IDataStateVariableProvider;
import org.fortiss.af3.component.ui.editor.datastate.DataStateTypeEditingSupport;
import org.fortiss.af3.component.ui.editor.datastate.DataStateValueEditingSupport;
import org.fortiss.af3.component.ui.editor.datastate.DataStateVariableNameEditingSupport;
import org.fortiss.af3.component.utils.BehaviorModelElementFactory;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.IVariableDefinition;
import org.fortiss.tooling.base.ui.contentprovider.TableContentProviderBase;
import org.fortiss.tooling.base.ui.editor.FormsEditorBase;
import org.fortiss.tooling.base.ui.utils.TableViewerUtils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.EditorBase;

public abstract class DataStateEditorBase<T extends IDataStateVariableProvider>
extends FormsEditorBase<T> {
    private TableViewer viewer;
    private final Adapter changeListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (notification.getNewValue() instanceof DataStateVariable) {
                DataStateVariable dsv = (DataStateVariable)notification.getNewValue();
                if (notification.getEventType() == 3) {
                    dsv.eAdapters().add((Object)DataStateEditorBase.this.changeListener);
                } else if (notification.getEventType() == 4) {
                    dsv.eAdapters().remove((Object)DataStateEditorBase.this.changeListener);
                }
            }
            if (!DataStateEditorBase.this.viewer.getTable().isDisposed()) {
                DataStateEditorBase.this.viewer.refresh();
            }
        }
    };

    protected void createSections() {
        this.createEditDataStateSection();
        this.registerAtModel();
    }

    private void createEditDataStateSection() {
        Composite client = this.createNewSection("Data State Variables", "This section defines the data state variables of the specification.");
        client.setLayout((Layout)new GridLayout(2, false));
        DataStateTableViewer tableViewer = new DataStateTableViewer(this);
        this.viewer = tableViewer.createTableViewer(client);
        GridDataFactory.fillDefaults().hint(650, 250).span(1, 5).applyTo((Control)this.viewer.getTable());
        Button b = this.toolkit.createButton(client, "Add", 8);
        b.setLayoutData((Object)new GridData(2));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataStateEditorBase.this.addNewVariable();
            }
        });
        b = this.toolkit.createButton(client, "Remove", 8);
        b.setLayoutData((Object)new GridData(2));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataStateEditorBase.this.removeSelectedVariable();
            }
        });
    }

    protected void addNewVariable() {
        String vName = "v" + (((IDataStateVariableProvider)this.getEditedObject()).getDataStateVariables().size() + 1);
        final DataStateVariable dsvar = BehaviorModelElementFactory.createDataStateVariable((String)vName, (IType)ExpressionModelElementFactory.intType(), (IExpressionTerm)ExpressionModelElementFactory.intConst((int)0));
        final ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor(this.getEditedObject());
        topLevel.runAsCommand(new Runnable(){

            @Override
            public void run() {
                topLevel.prepareIDs((EObject)dsvar);
                ((IDataStateVariableProvider)DataStateEditorBase.this.getEditedObject()).getDataStateVariables().add((Object)dsvar);
            }
        });
    }

    protected void removeSelectedVariable() {
        final DataStateVariable dsv = (DataStateVariable)SelectionUtils.checkAndPickFirstSafe((ISelection)this.viewer.getSelection(), DataStateVariable.class);
        if (dsv == null) {
            return;
        }
        ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor(this.getEditedObject());
        topLevel.runAsCommand(new Runnable(){

            @Override
            public void run() {
                EcoreUtil.delete((EObject)dsv, (boolean)true);
                ((IDataStateVariableProvider)DataStateEditorBase.this.getEditedObject()).getDataStateVariables().remove((Object)dsv);
            }
        });
    }

    private void registerAtModel() {
        ((IDataStateVariableProvider)this.getEditedObject()).eAdapters().add((Object)this.changeListener);
        for (DataStateVariable dsv : ((IDataStateVariableProvider)this.getEditedObject()).getDataStateVariables()) {
            dsv.eAdapters().add((Object)this.changeListener);
        }
    }

    public void dispose() {
        for (DataStateVariable dsv : ((IDataStateVariableProvider)this.getEditedObject()).getDataStateVariables()) {
            dsv.eAdapters().remove((Object)this.changeListener);
        }
        ((IDataStateVariableProvider)this.getEditedObject()).eAdapters().remove((Object)this.changeListener);
        super.dispose();
    }

    private class DataStateTableViewer
    extends TableContentProviderBase {
        private DataStateEditorBase<T> dataStateEditorBase;
        protected final ColumnLabelProvider[] clps = new ColumnLabelProvider[]{new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((DataStateVariable)element).getIdentifier();
            }
        }, new ColumnLabelProvider(){

            public String getText(Object element) {
                IType t = ((DataStateVariable)element).getType();
                return t != null ? t.toString() : "";
            }
        }, new ColumnLabelProvider(){

            public String getText(Object element) {
                IExpressionTerm t = ((DataStateVariable)element).getInitialValue();
                return t != null ? t.toString() : "";
            }
        }, new ColumnLabelProvider(){

            public String getText(Object element) {
                IType tpe = ((IVariableDefinition)element).getVariableType();
                if (tpe instanceof TInt) {
                    return Integer.toString(((TInt)tpe).getLowerBound());
                }
                return "";
            }
        }, new ColumnLabelProvider(){

            public String getText(Object element) {
                IType type = ((IVariableDefinition)element).getVariableType();
                if (type instanceof TInt) {
                    return Integer.toString(((TInt)type).getUpperBound());
                }
                return "";
            }
        }};

        public DataStateTableViewer(DataStateEditorBase<T> dataStateEditorBase2) {
            this.dataStateEditorBase = dataStateEditorBase2;
        }

        protected int compare(Viewer viewer, Object o1, Object o2) {
            return ((DataStateVariable)o1).getIdentifier().compareTo(((DataStateVariable)o2).getIdentifier());
        }

        protected void createColumns(TableViewer viewer) {
            TableViewerUtils.createColumn((TableViewer)viewer, (int)this.getBounds()[0], (String)this.getTitles()[0], (String)this.getTooltips()[0], (ColumnLabelProvider)this.clps[0], (EditingSupport)new DataStateVariableNameEditingSupport((EditorBase<? extends EObject>)this.dataStateEditorBase, (ColumnViewer)viewer, (DataBindingContext)DataStateEditorBase.this.dbc, this.getContentObject()));
            TableViewerUtils.createColumn((TableViewer)viewer, (int)this.getBounds()[1], (String)this.getTitles()[1], (String)this.getTooltips()[1], (ColumnLabelProvider)this.clps[1], (EditingSupport)new DataStateTypeEditingSupport((EditorBase<? extends EObject>)this.dataStateEditorBase, (ColumnViewer)viewer, (DataBindingContext)DataStateEditorBase.this.dbc, this.getContentObject()));
            TableViewerUtils.createColumn((TableViewer)viewer, (int)this.getBounds()[2], (String)this.getTitles()[2], (String)this.getTooltips()[2], (ColumnLabelProvider)this.clps[2], (EditingSupport)new DataStateValueEditingSupport((EditorBase<? extends EObject>)this.dataStateEditorBase, (ColumnViewer)viewer, (DataBindingContext)DataStateEditorBase.this.dbc, this.getContentObject()));
            this.createBoundsColumns(viewer);
        }

        private void createBoundsColumns(TableViewer viewer) {
            TableViewerUtils.createColumn((TableViewer)viewer, (int)this.getBounds()[3], (String)this.getTitles()[3], (String)this.getTooltips()[3], (ColumnLabelProvider)this.clps[3], (EditingSupport)new TableViewerUtils.IntegerEditingSupport((ColumnViewer)viewer, (Composite)viewer.getTable()){

                protected void setValue(Object element, Object value) {
                    IType type = ((IVariableDefinition)element).getVariableType();
                    if (!(type instanceof TInt)) {
                        return;
                    }
                    final TInt intType = (TInt)type;
                    final int newLower = Integer.parseInt(value.toString());
                    if (newLower != intType.getLowerBound()) {
                        TInt tint = (TInt)((IVariableDefinition)element).getVariableType();
                        ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)tint);
                        topLevel.runAsCommand(new Runnable(){

                            @Override
                            public void run() {
                                intType.setLowerBound(newLower);
                            }
                        });
                        this.getViewer().refresh();
                    }
                }

                protected Object getValue(Object element) {
                    IType type = ((IVariableDefinition)element).getVariableType();
                    if (type instanceof TInt) {
                        return Integer.toString(((TInt)type).getLowerBound());
                    }
                    return "";
                }

                protected boolean canEdit(Object element) {
                    return super.canEdit(element) && ((IVariableDefinition)element).getVariableType() instanceof TInt;
                }
            });
            TableViewerUtils.createColumn((TableViewer)viewer, (int)this.getBounds()[4], (String)this.getTitles()[4], (String)this.getTooltips()[4], (ColumnLabelProvider)this.clps[4], (EditingSupport)new TableViewerUtils.IntegerEditingSupport((ColumnViewer)viewer, (Composite)viewer.getTable()){

                protected void setValue(Object element, Object value) {
                    IType type = ((IVariableDefinition)element).getVariableType();
                    if (!(type instanceof TInt)) {
                        return;
                    }
                    TInt intType = (TInt)type;
                    final int newUpper = Integer.parseInt(value.toString());
                    if (newUpper != intType.getUpperBound()) {
                        final TInt tint = (TInt)((IVariableDefinition)element).getVariableType();
                        ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)tint);
                        topLevel.runAsCommand(new Runnable(){

                            @Override
                            public void run() {
                                tint.setUpperBound(newUpper);
                            }
                        });
                        this.getViewer().refresh();
                    }
                }

                protected Object getValue(Object element) {
                    IType type = ((IVariableDefinition)element).getVariableType();
                    if (type instanceof TInt) {
                        return Integer.toString(((TInt)type).getUpperBound());
                    }
                    return "";
                }

                protected boolean canEdit(Object element) {
                    return super.canEdit(element) && ((IVariableDefinition)element).getVariableType() instanceof TInt;
                }
            });
        }

        protected EObject getContentObject() {
            return DataStateEditorBase.this.getEditedObject();
        }

        public Object[] getElements(Object inputElement) {
            return ((IDataStateVariableProvider)DataStateEditorBase.this.getEditedObject()).getDataStateVariables().toArray();
        }

        protected String[] getTitles() {
            return new String[]{"Variable", "Type", "Initial Value", "Lower Bound", "Upper Bound"};
        }

        protected String[] getTooltips() {
            return new String[]{"Variable Name", "Variable Type", "Initial Value", "Lower Bound", "Upper Bound"};
        }

        protected int[] getBounds() {
            return new int[]{120, 120, 120, 150, 150};
        }
    }
}

