/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.editor.datastate;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.fortiss.af3.component.model.behavior.common.CommonPackage;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.expression.ui.complexdata.ComplexDataDialogCellEditor;
import org.fortiss.af3.expression.ui.databinding.convert.ITermToStringConverter;
import org.fortiss.af3.expression.ui.databinding.convert.StringToIExpressionTermConverter;
import org.fortiss.af3.expression.ui.databinding.validate.StringToIExpressionTermWithTypeCheckValidatorBase;
import org.fortiss.af3.expression.utils.ExpressionUtils;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.kernel.ui.databinding.AbstractDecoratedStyledTextCellDatabindingEditingSupport;
import org.fortiss.tooling.kernel.ui.extension.base.EditorBase;
import org.fortiss.tooling.kernel.ui.util.ObservableUtils;

class DataStateValueEditingSupport
extends AbstractDecoratedStyledTextCellDatabindingEditingSupport {
    private EObject model;

    public DataStateValueEditingSupport(EditorBase<? extends EObject> editor, ColumnViewer viewer, DataBindingContext dbc, EObject model) {
        super(editor, viewer, dbc);
        this.model = model;
    }

    protected IObservableValue<?> getModelObservableValue(Object model) {
        return ObservableUtils.observeValue((EObject)((DataStateVariable)model), (EStructuralFeature)CommonPackage.Literals.DATA_STATE_VARIABLE__INITIAL_VALUE);
    }

    protected IConverter getModelToTextConverter() {
        return new ITermToStringConverter();
    }

    protected IConverter getTextToModelConverter() {
        return new StringToIExpressionTermConverter(this.model);
    }

    protected IValidator getTextValidator(final Object element) {
        return new StringToIExpressionTermWithTypeCheckValidatorBase(this.model){

            protected boolean isNoValAllowed() {
                return false;
            }

            protected String getUnknownTypeMessage() {
                return "Unknown type " + String.valueOf(this.getType()) + ". Cannot verify value. ";
            }

            protected IType getType() {
                return ((DataStateVariable)element).getType();
            }
        };
    }

    public final CellEditor getCellEditor(Object model) {
        if (this.isComplexCellEditor(model)) {
            this.cellEditor = this.createComplexCellEditor(this.getViewer(), model);
            this.setupCellEditor(this.cellEditor);
        } else {
            this.cellEditor = this.createCellEditor(this.getViewer());
        }
        return this.cellEditor;
    }

    protected CellEditor createComplexCellEditor(ColumnViewer viewer, Object model) {
        DataStateVariable dsv = (DataStateVariable)model;
        ComplexDataDialogCellEditor complexDataDialogCellEditor = new ComplexDataDialogCellEditor((Composite)((Table)viewer.getControl()));
        complexDataDialogCellEditor.initialize("VariableValue", dsv.getIdentifier(), (EObject)dsv, dsv.getVariableType(), dsv.getInitialValue(), true);
        return complexDataDialogCellEditor;
    }

    protected boolean isComplexCellEditor(Object model) {
        DataStateVariable dsv = (DataStateVariable)model;
        return ExpressionUtils.isComplexDataType((IType)dsv.getVariableType(), (EObject)dsv);
    }

    protected Text getText(CellEditor cellEditor) {
        if (cellEditor instanceof TextCellEditor) {
            return (Text)cellEditor.getControl();
        }
        if (cellEditor instanceof ComplexDataDialogCellEditor) {
            return ((ComplexDataDialogCellEditor)cellEditor).getText();
        }
        return null;
    }
}

