/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.editor.structure.visual;

import java.util.Collection;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.tooling.base.ui.editor.fx.visual.NamedLayoutedLineLinkVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.util.GraphicUtils;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.ui.ToolingKernelUIActivator;
import org.fortiss.tooling.kernel.ui.service.IMarkerService;

public class ChannelVisual
extends NamedLayoutedLineLinkVisual<Channel> {
    private Label errorWarning = null;

    public ChannelVisual(ILinkMVCBundle mvcb) {
        super(mvcb, Channel.class);
    }

    public void updateNodes(DiagramLayers layers) {
        Channel modelElement;
        IMarkerService markerService;
        IConstraintViolation.ESeverity highest;
        super.updateNodes(layers);
        if (this.errorWarning != null) {
            layers.getVisualFeedbackLayer().remove((Node)this.errorWarning);
            this.errorWarning = null;
        }
        if ((highest = (markerService = IMarkerService.getInstance()).getHighestViolationSeverity((EObject)(modelElement = (Channel)this.getModelElement()))) == null) {
            return;
        }
        if (highest != IConstraintViolation.ESeverity.ERROR && highest != IConstraintViolation.ESeverity.WARNING) {
            return;
        }
        Collection violations = markerService.getAllViolationsWithSeverity(highest);
        if (violations.isEmpty()) {
            return;
        }
        String imgFile = highest == IConstraintViolation.ESeverity.WARNING ? "warning.png" : "error.png";
        Image img = GraphicUtils.getFXImage((String)ToolingKernelUIActivator.PLUGIN_ID, (String)("icons/" + imgFile));
        this.errorWarning = new Label("");
        this.errorWarning.setGraphic((Node)new ImageView(img));
        DiagramCoordinate sp = this.getStartAnchorPoint();
        DiagramCoordinate ep = this.getEndAnchorPoint();
        if (this.getNumberOfBendPoints() > 0) {
            ep = this.getBendPointLocation(0);
        }
        double x = sp.getX() + (ep.getX() - sp.getX()) / 2.0;
        double y = sp.getY() + (ep.getY() - sp.getY()) / 2.0 - img.getHeight();
        this.errorWarning.setTranslateX(x);
        this.errorWarning.setTranslateY(y);
        layers.getVisualFeedbackLayer().add((Node)this.errorWarning, this.getMVCBundle());
        this.errorWarning.setOnMouseEntered(null);
        this.errorWarning.setOnMouseExited(null);
        Tooltip tooltip = new Tooltip(((IConstraintViolation)violations.iterator().next()).getExplanation());
        tooltip.setGraphic((Node)new ImageView(img));
        Tooltip.install((Node)this.errorWarning, (Tooltip)tooltip);
    }
}

