/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.editor.structure.visual;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.ui.AF3ComponentUIActivator;
import org.fortiss.af3.component.ui.DefaultStyle;
import org.fortiss.af3.safety.model.archpat.ArchitecturePatternSpecification;
import org.fortiss.tooling.base.ui.editor.fx.visual.NamedLayoutedRectangularContentVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.util.GraphicUtils;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.ui.ToolingKernelUIActivator;
import org.fortiss.tooling.kernel.ui.service.IMarkerService;
import org.fortiss.tooling.kernel.ui.service.INavigatorService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public final class ContentComponentVisual
extends NamedLayoutedRectangularContentVisual<Component> {
    private static final int HIT_AREA_REDUCTION_QUOTIENT = 4;
    public static final String PLUGIN_ID = AF3ComponentUIActivator.class.getPackage().getName();
    private static Image WEAKLY_CAUSAL_ICON = GraphicUtils.getFXImage((String)PLUGIN_ID, (String)"/icons/component.gif");
    private static Image STRONGLY_CAUSAL_ICON = GraphicUtils.getFXImage((String)PLUGIN_ID, (String)"/icons/component_stronglycausal.gif");
    private static final Color COMPOSITE_COLOR = GraphicUtils.convertColor((org.eclipse.swt.graphics.Color)DefaultStyle.SUBSTRUCTURE_COMPONENT_BACKGROUND);
    private static final Color STRONGLY_CAUSAL_COLOR = GraphicUtils.convertColor((org.eclipse.swt.graphics.Color)DefaultStyle.STRONGLY_CAUSAL_COMPONENT_BACKGROUND);
    private static final Color WEAKLY_CAUSAL_COLOR = GraphicUtils.convertColor((org.eclipse.swt.graphics.Color)DefaultStyle.WEAKLY_CAUSAL_COMPONENT_BACKGROUND);
    private static final Color[] ARCHITECTURE_PATTERN_COLORS = new Color[]{Color.AQUAMARINE, Color.AZURE, Color.BLUE, Color.BROWN, Color.CADETBLUE, Color.CHOCOLATE};
    private static int colorIndex = 0;
    private static Map<ArchitecturePatternSpecification, Color> patternColorMap = new HashMap<ArchitecturePatternSpecification, Color>();
    private Tooltip tooltip;

    public ContentComponentVisual(IContentMVCBundle mvcb) {
        super(mvcb, Component.class);
    }

    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        IMarkerService markerService = IMarkerService.getInstance();
        IConstraintViolation.ESeverity highest = markerService.getHighestViolationSeverity((EObject)this.getModelElement());
        if (this.tooltip != null) {
            Tooltip.uninstall((Node)this.getHitAreaRectangleShape(), (Tooltip)this.tooltip);
        }
        if (highest == null) {
            return;
        }
        if (highest == IConstraintViolation.ESeverity.WARNING || highest == IConstraintViolation.ESeverity.ERROR) {
            Collection violations = markerService.getAllViolationsWithSeverity(highest);
            if (violations.isEmpty()) {
                return;
            }
            String imgFile = highest == IConstraintViolation.ESeverity.WARNING ? "warning.png" : "error.png";
            Image img = GraphicUtils.getFXImage((String)ToolingKernelUIActivator.PLUGIN_ID, (String)("icons/" + imgFile));
            this.icon.setImage(img);
            String explanation = ((IConstraintViolation)violations.iterator().next()).getExplanation();
            this.tooltip = new Tooltip(explanation);
            this.tooltip.setGraphic((Node)new ImageView(img));
            Tooltip.install((Node)this.getHitAreaRectangleShape(), (Tooltip)this.tooltip);
        }
    }

    protected Paint getFillColor() {
        Component cmp = (Component)this.getModelElement();
        Component parentComp = cmp.getParentComponent();
        boolean isExpertMode = INavigatorService.getInstance().isExpertViewActive();
        if (isExpertMode && parentComp != null) {
            for (ArchitecturePatternSpecification apSpec : EcoreUtils.pickInstanceOf(ArchitecturePatternSpecification.class, (List)parentComp.getSpecifications())) {
                if (!apSpec.getModelElements().contains((Object)cmp)) continue;
                return ContentComponentVisual.getPatternColor(apSpec);
            }
        }
        if (cmp.getSubComponents().isEmpty()) {
            if (cmp.isStronglyCausal()) {
                return STRONGLY_CAUSAL_COLOR;
            }
            return WEAKLY_CAUSAL_COLOR;
        }
        return COMPOSITE_COLOR;
    }

    private static synchronized Color getPatternColor(ArchitecturePatternSpecification apSpec) {
        Color patternColor = patternColorMap.get(apSpec);
        if (patternColor == null) {
            patternColor = ARCHITECTURE_PATTERN_COLORS[colorIndex++];
            colorIndex %= ARCHITECTURE_PATTERN_COLORS.length;
            patternColorMap.put(apSpec, patternColor);
        }
        return patternColor;
    }

    protected Image getIcon() {
        Component cmp = (Component)this.getModelElement();
        if (cmp.getSubComponents().isEmpty()) {
            if (cmp.isStronglyCausal()) {
                return STRONGLY_CAUSAL_ICON;
            }
            return WEAKLY_CAUSAL_ICON;
        }
        return null;
    }

    protected double getHitAreaStartLinkSize() {
        return super.getHitAreaStartLinkSize() / 4.0;
    }
}

