/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.examples;

import java.util.HashMap;
import org.conqat.lib.commons.collections.Pair;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.AF3ComponentActivator;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.behavior.code.CodeSpecification;
import org.fortiss.af3.component.utils.BehaviorModelElementFactory;
import org.fortiss.af3.component.utils.ComponentModelElementFactory;
import org.fortiss.af3.expression.examples.SimpleTrafficLightsDataDictionaryExample;
import org.fortiss.af3.expression.language.Compiler;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.model.ProjectConfiguration;
import org.fortiss.af3.project.model.execution.ExecutionConfiguration;
import org.fortiss.af3.project.model.execution.ExecutionConfigurationStore;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeSystem;
import org.fortiss.af3.project.utils.FileUtils;
import org.fortiss.af3.project.utils.ProjectModelElementFactory;
import org.fortiss.tooling.base.model.layout.EOrientation;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class SimpleTrafficLightsComponentArchitectureExample
extends SimpleTrafficLightsDataDictionaryExample {
    protected int GRIDSIZE = 12;
    protected static Compiler compiler = new Compiler();

    protected SimpleTrafficLightsComponentArchitectureExample() {
    }

    public FileProject createProject(String projectName) {
        FileProject project = ProjectModelElementFactory.createFileProject((String)projectName, (ProjectConfiguration)ProjectModelElementFactory.createProjectConfiguration((ITypeSystem)ExpressionModelElementFactory.createMicroTypesystem()));
        this.createDataDictionary(project);
        this.createComponents(project);
        ComponentModelElementFactory.createExecutionConfig((FileProject)project, (String)"TrafficLights Execution Configuration");
        UniqueIDUtils.generateAllIDs((EObject)project);
        this.setExecutionConfigReferencedID(project);
        return project;
    }

    protected void setExecutionConfigReferencedID(FileProject project) {
        int ComponentArchitectureID = 0;
        ExecutionConfiguration executionConfiguration = null;
        for (IProjectRootElement element : project.getRootElements()) {
            if (element instanceof ComponentArchitecture && element.getName().equals("TL-Component-Architecture")) {
                ComponentArchitectureID = element.getId();
            }
            if (!(element instanceof ExecutionConfigurationStore)) continue;
            executionConfiguration = (ExecutionConfiguration)((ExecutionConfigurationStore)element).getConfigurations().get(0);
        }
        if (ComponentArchitectureID != 0 && executionConfiguration != null) {
            executionConfiguration.setIdReference(ComponentArchitectureID);
        }
    }

    protected void createComponents(FileProject project) {
        Pair<Component, HashMap<String, Port>> tlarchPair = this.createComponentArchitecture(project);
        Component tlarch = (Component)tlarchPair.getFirst();
        HashMap tlarchPorts = (HashMap)tlarchPair.getSecond();
        Pair<Component, HashMap<String, Port>> mergePair = this.createComponentMerge(tlarch);
        Component merge = (Component)mergePair.getFirst();
        HashMap mergePorts = (HashMap)mergePair.getSecond();
        Pair<Component, HashMap<String, Port>> ctrlPair = this.createComponentController(tlarch);
        Component ctrl = (Component)ctrlPair.getFirst();
        HashMap ctrlPorts = (HashMap)ctrlPair.getSecond();
        Pair<Component, HashMap<String, Port>> behaviorPair = this.createComponentBehavior(ctrl);
        Component behavior = (Component)behaviorPair.getFirst();
        HashMap behaviorPorts = (HashMap)behaviorPair.getSecond();
        this.createComponentBehaviorMerge((Component)mergePair.getFirst());
        this.createComponentBehaviorBehavior(behavior);
        ComponentModelElementFactory.createChannelAndAttach((Component)tlarch, (String)"buttonA", (Port)((Port)tlarchPorts.get("tlarchInButtonA")), (Port)((Port)mergePorts.get("mergeInButtonA")));
        ComponentModelElementFactory.createChannelAndAttach((Component)tlarch, (String)"buttonB", (Port)((Port)tlarchPorts.get("tlarchInButtonB")), (Port)((Port)mergePorts.get("mergeInButtonB")));
        ComponentModelElementFactory.createChannelAndAttach((Component)tlarch, (String)"request", (Port)((Port)mergePorts.get("mergeOutRequest")), (Port)((Port)ctrlPorts.get("ctrlInRequest")));
        ComponentModelElementFactory.createChannelAndAttach((Component)ctrl, (String)"request", (Port)((Port)ctrlPorts.get("ctrlInRequest")), (Port)((Port)behaviorPorts.get("behaviorInRequest")));
        ComponentModelElementFactory.createChannelAndAttach((Component)ctrl, (String)"trafficSignal", (Port)((Port)behaviorPorts.get("behaviorOutTrafficSignal")), (Port)((Port)ctrlPorts.get("ctrlOutTrafficSignal")));
        ComponentModelElementFactory.createChannelAndAttach((Component)ctrl, (String)"pedestrianSignal", (Port)((Port)behaviorPorts.get("behaviorOutPedestrianSignal")), (Port)((Port)ctrlPorts.get("ctrlOutPedestrianSignal")));
        Channel channelA = ComponentModelElementFactory.createChannelAndAttach((Component)ctrl, (String)"indicatorSignalA", (Port)((Port)behaviorPorts.get("behaviorOutIndicatorSignal")), (Port)((Port)ctrlPorts.get("ctrlOutIndicatorSignalA")));
        Channel channelB = ComponentModelElementFactory.createChannelAndAttach((Component)ctrl, (String)"indicatorSignalB", (Port)((Port)behaviorPorts.get("behaviorOutIndicatorSignal")), (Port)((Port)ctrlPorts.get("ctrlOutIndicatorSignalB")));
        ComponentModelElementFactory.createChannelAndAttach((Component)tlarch, (String)"trafficSignal", (Port)((Port)ctrlPorts.get("ctrlOutTrafficSignal")), (Port)((Port)tlarchPorts.get("tlarchOutTrafficSignal")));
        ComponentModelElementFactory.createChannelAndAttach((Component)tlarch, (String)"pedestrianSignal", (Port)((Port)ctrlPorts.get("ctrlOutPedestrianSignal")), (Port)((Port)tlarchPorts.get("tlarchOutPedestrianSignal")));
        ComponentModelElementFactory.createChannelAndAttach((Component)tlarch, (String)"indicatorSignalA", (Port)((Port)ctrlPorts.get("ctrlOutIndicatorSignalA")), (Port)((Port)tlarchPorts.get("tlarchOutIndicatorSignalA")));
        ComponentModelElementFactory.createChannelAndAttach((Component)tlarch, (String)"indicatorSignalB", (Port)((Port)ctrlPorts.get("ctrlOutIndicatorSignalB")), (Port)((Port)tlarchPorts.get("tlarchOutIndicatorSignalB")));
        LayoutDataUtils.addBendPointToConnection((ILayoutedModelElement)channelA, (int)(this.GRIDSIZE * 40), (int)(this.GRIDSIZE * 21));
        LayoutDataUtils.addBendPointToConnection((ILayoutedModelElement)channelB, (int)(this.GRIDSIZE * 40), (int)(this.GRIDSIZE * 29));
        tlarch.getContainedElements().add((Object)merge);
        tlarch.getContainedElements().add((Object)ctrl);
    }

    protected Pair<Component, HashMap<String, Port>> createComponentArchitecture(FileProject project) {
        HashMap<String, Object> ports = new HashMap<String, Object>();
        Component tlarch = ComponentModelElementFactory.createComponentArchitecture((FileProject)project, (String)"TL-Component-Architecture", (String)"TL-Architecture");
        InputPort tlarchInButtonA = ComponentModelElementFactory.createInputPortAndAttach((Component)tlarch, (String)"tlarchInButtonA", (IType)this.signalEnum.createIType(), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)tlarchInButtonA, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 4));
        ports.put(tlarchInButtonA.getName(), tlarchInButtonA);
        InputPort tlarchInButtonB = ComponentModelElementFactory.createInputPortAndAttach((Component)tlarch, (String)"tlarchInButtonB", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.signalEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)tlarchInButtonB, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 10));
        ports.put(tlarchInButtonB.getName(), tlarchInButtonB);
        OutputPort tlarchOutTrafficSignal = ComponentModelElementFactory.createOutputPortAndAttach((Component)tlarch, (String)"tlarchOutTrafficSignal", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.trafficColorEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)tlarchOutTrafficSignal, (int)(this.GRIDSIZE * 70), (int)(this.GRIDSIZE * 4));
        ports.put(tlarchOutTrafficSignal.getName(), tlarchOutTrafficSignal);
        OutputPort tlarchOutPedestrianSignal = ComponentModelElementFactory.createOutputPortAndAttach((Component)tlarch, (String)"tlarchOutPedestrianSignal", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.pedestrianColorEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)tlarchOutPedestrianSignal, (int)(this.GRIDSIZE * 70), (int)(this.GRIDSIZE * 12));
        ports.put(tlarchOutPedestrianSignal.getName(), tlarchOutPedestrianSignal);
        OutputPort tlarchOutIndicatorSignalA = ComponentModelElementFactory.createOutputPortAndAttach((Component)tlarch, (String)"tlarchOutIndicatorSignalA", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.indicatorSignalEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)tlarchOutIndicatorSignalA, (int)(this.GRIDSIZE * 70), (int)(this.GRIDSIZE * 20));
        ports.put(tlarchOutIndicatorSignalA.getName(), tlarchOutIndicatorSignalA);
        OutputPort tlarchOutIndicatorSignalB = ComponentModelElementFactory.createOutputPortAndAttach((Component)tlarch, (String)"tlarchOutIndicatorSignalB", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.indicatorSignalEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)tlarchOutIndicatorSignalB, (int)(this.GRIDSIZE * 70), (int)(this.GRIDSIZE * 28));
        ports.put(tlarchOutIndicatorSignalB.getName(), tlarchOutIndicatorSignalB);
        return new Pair((Object)tlarch, ports);
    }

    protected Pair<Component, HashMap<String, Port>> createComponentMerge(Component parent) {
        HashMap<String, Object> ports = new HashMap<String, Object>();
        Component merge = ComponentModelElementFactory.createComponentAndAttach((Component)parent, (String)"Merge", (boolean)false);
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)merge, (int)(this.GRIDSIZE * 14), (int)(this.GRIDSIZE * 2), (int)216, (int)(this.GRIDSIZE * 12));
        InputPort mergeInButtonA = ComponentModelElementFactory.createInputPortAndAttach((Component)merge, (String)"mergeInButtonA", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.signalEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)mergeInButtonA, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 2));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)mergeInButtonA, (EOrientation)EOrientation.WEST, (int)(this.GRIDSIZE * 2));
        ports.put(mergeInButtonA.getName(), mergeInButtonA);
        InputPort mergeInButtonB = ComponentModelElementFactory.createInputPortAndAttach((Component)merge, (String)"mergeInButtonB", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.signalEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)mergeInButtonB, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 4));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)mergeInButtonB, (EOrientation)EOrientation.WEST, (int)(this.GRIDSIZE * 8));
        ports.put(mergeInButtonB.getName(), mergeInButtonB);
        OutputPort mergeOutRequest = ComponentModelElementFactory.createOutputPortAndAttach((Component)merge, (String)"mergeOutRequest", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.signalEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)mergeOutRequest, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 6));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)mergeOutRequest, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 2));
        ports.put(mergeOutRequest.getName(), mergeOutRequest);
        return new Pair((Object)merge, ports);
    }

    protected Pair<Component, HashMap<String, Port>> createComponentController(Component parent) {
        HashMap<String, Object> ports = new HashMap<String, Object>();
        Component ctrl = ComponentModelElementFactory.createComponentAndAttach((Component)parent, (String)"Controller", (boolean)false);
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)ctrl, (int)(this.GRIDSIZE * 42), (int)(this.GRIDSIZE * 2), (int)216, (int)(this.GRIDSIZE * 30));
        InputPort ctrlInRequest = ComponentModelElementFactory.createInputPortAndAttach((Component)ctrl, (String)"ctrlInRequest", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.signalEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)ctrlInRequest, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 4));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)ctrlInRequest, (EOrientation)EOrientation.WEST, (int)(this.GRIDSIZE * 2));
        ports.put(ctrlInRequest.getName(), ctrlInRequest);
        OutputPort ctrlOutTrafficSignal = ComponentModelElementFactory.createOutputPortAndAttach((Component)ctrl, (String)"ctrlOutTrafficSignal", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.trafficColorEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)ctrlOutTrafficSignal, (int)(this.GRIDSIZE * 42), (int)(this.GRIDSIZE * 4));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)ctrlOutTrafficSignal, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 2));
        ports.put(ctrlOutTrafficSignal.getName(), ctrlOutTrafficSignal);
        OutputPort ctrlOutPedestrianSignal = ComponentModelElementFactory.createOutputPortAndAttach((Component)ctrl, (String)"ctrlOutPedestrianSignal", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.pedestrianColorEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)ctrlOutPedestrianSignal, (int)(this.GRIDSIZE * 42), (int)(this.GRIDSIZE * 12));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)ctrlOutPedestrianSignal, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 10));
        ports.put(ctrlOutPedestrianSignal.getName(), ctrlOutPedestrianSignal);
        OutputPort ctrlOutIndicatorSignalA = ComponentModelElementFactory.createOutputPortAndAttach((Component)ctrl, (String)"ctrlOutIndicatorSignalA", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.indicatorSignalEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)ctrlOutIndicatorSignalA, (int)(this.GRIDSIZE * 42), (int)(this.GRIDSIZE * 20));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)ctrlOutIndicatorSignalA, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 18));
        ports.put(ctrlOutIndicatorSignalA.getName(), ctrlOutIndicatorSignalA);
        OutputPort ctrlOutIndicatorSignalB = ComponentModelElementFactory.createOutputPortAndAttach((Component)ctrl, (String)"ctrlOutIndicatorSignalB", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.indicatorSignalEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)ctrlOutIndicatorSignalB, (int)(this.GRIDSIZE * 42), (int)(this.GRIDSIZE * 28));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)ctrlOutIndicatorSignalB, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 26));
        ports.put(ctrlOutIndicatorSignalB.getName(), ctrlOutIndicatorSignalB);
        return new Pair((Object)ctrl, ports);
    }

    protected Pair<Component, HashMap<String, Port>> createComponentBehavior(Component parent) {
        HashMap<String, Object> ports = new HashMap<String, Object>();
        Component behavior = ComponentModelElementFactory.createComponentAndAttach((Component)parent, (String)"Behavior", (boolean)true);
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)behavior, (int)(this.GRIDSIZE * 14), (int)(this.GRIDSIZE * 2), (int)216, (int)(this.GRIDSIZE * 30));
        InputPort behaviorInRequest = ComponentModelElementFactory.createInputPortAndAttach((Component)behavior, (String)"behaviorInRequest", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.signalEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)behaviorInRequest, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 2));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)behaviorInRequest, (EOrientation)EOrientation.WEST, (int)(this.GRIDSIZE * 2));
        ports.put(behaviorInRequest.getName(), behaviorInRequest);
        OutputPort behaviorOutTrafficSignal = ComponentModelElementFactory.createOutputPortAndAttach((Component)behavior, (String)"behaviorOutTrafficSignal", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.trafficColorEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)behaviorOutTrafficSignal, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 4));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)behaviorOutTrafficSignal, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 2));
        ports.put(behaviorOutTrafficSignal.getName(), behaviorOutTrafficSignal);
        OutputPort behaviorOutPedestrianSignal = ComponentModelElementFactory.createOutputPortAndAttach((Component)behavior, (String)"behaviorOutPedestrianSignal", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.pedestrianColorEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)behaviorOutPedestrianSignal, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 6));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)behaviorOutPedestrianSignal, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 10));
        ports.put(behaviorOutPedestrianSignal.getName(), behaviorOutPedestrianSignal);
        OutputPort behaviorOutIndicatorSignal = ComponentModelElementFactory.createOutputPortAndAttach((Component)behavior, (String)"behaviorOutIndicatorSignal", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.indicatorSignalEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)behaviorOutIndicatorSignal, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 8));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)behaviorOutIndicatorSignal, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 22));
        ports.put(behaviorOutIndicatorSignal.getName(), behaviorOutIndicatorSignal);
        return new Pair((Object)behavior, ports);
    }

    protected void createComponentBehaviorMerge(Component merge) {
        String codeSpecString = FileUtils.loadTextFileFromPlugin((URI)URI.createPlatformPluginURI((String)(AF3ComponentActivator.PLUGIN_ID + "/test-data/SimpleTrafficLights_Merge_CodeSpec.txt"), (boolean)true));
        CodeSpecification codeSpec = BehaviorModelElementFactory.createCodeSpecification((StatementSequence)compiler.compileStatementTerm(codeSpecString));
        merge.getSpecifications().add((Object)codeSpec);
    }

    protected void createComponentBehaviorBehavior(Component behavior) {
        InputPort behaviorStateIn = ComponentModelElementFactory.createInputPortAndAttach((Component)behavior, (String)"behaviorInState", (IType)ExpressionModelElementFactory.intType(), (IExpressionTerm)compiler.compileTerm("0", (EObject)this.dd));
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)behaviorStateIn, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 10));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)behaviorStateIn, (EOrientation)EOrientation.SOUTH, (int)(this.GRIDSIZE * 2));
        InputPort behaviorTimeIn = ComponentModelElementFactory.createInputPortAndAttach((Component)behavior, (String)"behaviorInTime", (IType)ExpressionModelElementFactory.intType(), (IExpressionTerm)compiler.compileTerm("0", (EObject)this.dd));
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)behaviorTimeIn, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 12));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)behaviorTimeIn, (EOrientation)EOrientation.SOUTH, (int)(this.GRIDSIZE * 4));
        OutputPort behaviorTimeOut = ComponentModelElementFactory.createOutputPortAndAttach((Component)behavior, (String)"behaviorOutTime", (IType)ExpressionModelElementFactory.intType(), (IExpressionTerm)compiler.compileTerm("0", (EObject)this.dd));
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)behaviorTimeOut, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 14));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)behaviorTimeOut, (EOrientation)EOrientation.SOUTH, (int)(this.GRIDSIZE * 12));
        OutputPort behaviorStateOut = ComponentModelElementFactory.createOutputPortAndAttach((Component)behavior, (String)"behaviorOutState", (IType)ExpressionModelElementFactory.intType(), (IExpressionTerm)compiler.compileTerm("0", (EObject)this.dd));
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)behaviorStateOut, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 16));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)behaviorStateOut, (EOrientation)EOrientation.SOUTH, (int)(this.GRIDSIZE * 14));
        Channel timeFeedback = ComponentModelElementFactory.createChannelAndAttach((Component)behavior.getParentComponent(), (String)"time", (Port)behaviorTimeOut, (Port)behaviorTimeIn);
        Channel stateFeedback = ComponentModelElementFactory.createChannelAndAttach((Component)behavior.getParentComponent(), (String)"state", (Port)behaviorStateOut, (Port)behaviorStateIn);
        LayoutDataUtils.addBendPointToConnection((ILayoutedModelElement)timeFeedback, (int)(this.GRIDSIZE * 27), (int)(this.GRIDSIZE * 34));
        LayoutDataUtils.addBendPointToConnection((ILayoutedModelElement)timeFeedback, (int)(this.GRIDSIZE * 19), (int)(this.GRIDSIZE * 34));
        LayoutDataUtils.addBendPointToConnection((ILayoutedModelElement)stateFeedback, (int)(this.GRIDSIZE * 29), (int)(this.GRIDSIZE * 36));
        LayoutDataUtils.addBendPointToConnection((ILayoutedModelElement)stateFeedback, (int)(this.GRIDSIZE * 17), (int)(this.GRIDSIZE * 36));
        String codeSpecString = FileUtils.loadTextFileFromPlugin((URI)URI.createPlatformPluginURI((String)(AF3ComponentActivator.PLUGIN_ID + "/test-data/SimpleTrafficLights_Behavior_CodeSpec.txt"), (boolean)true));
        CodeSpecification codeSpec = BehaviorModelElementFactory.createCodeSpecification((StatementSequence)compiler.compileStatementTerm(codeSpecString));
        behavior.getSpecifications().add((Object)codeSpec);
    }
}

