/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.generator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.ui.AF3ComponentUIActivator;
import org.fortiss.af3.component.ui.generator.FMUGeneratorExecutionTarget;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.af3.project.extension.IExecutionTarget;
import org.fortiss.af3.project.services.IExecutionService;
import org.fortiss.af3.project.ui.execution.EasyStartMenuBase;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.service.INavigatorService;

public class FMUGeneratorEasyStartMenu
extends EasyStartMenuBase {
    public FMUGeneratorEasyStartMenu() {
        super(FMUGeneratorEasyStartMenu.getFMUGeneratorTargetFromExecutionService());
    }

    private static IExecutionTarget getFMUGeneratorTargetFromExecutionService() {
        return IExecutionService.INSTANCE.getSpecificExecutionTarget(FMUGeneratorExecutionTarget.class);
    }

    public String getMenuSectionID() {
        return "bottommost";
    }

    protected boolean acceptSelection(INamedElement selection, ContextMenuContextProvider contextProvider) {
        return (selection instanceof ComponentArchitecture || selection instanceof Component) && INavigatorService.getInstance().isNavigatorView(contextProvider) && !ComponentArchitectureUtils.containsReadOnlyBehaviorSpecification((EObject)selection);
    }

    protected String getActionName() {
        return "Export as single FMU";
    }

    protected ImageDescriptor getActionIcon() {
        return AF3ComponentUIActivator.getImageDescriptor("icons/FMU_16x16.png");
    }

    protected String getStartupFailureMessage(Exception e) {
        Object str = "The FMU generator failed. Please check if your model is free of error markers and every component has a defined behavior. Please consult the error log for detailed error information.";
        Throwable lastException = e;
        while (lastException.getCause() != null && lastException.getCause().getMessage() != null) {
            lastException = lastException.getCause();
        }
        str = (String)str + "\n\nDetailed errors:\n";
        if (lastException != e) {
            return (String)str + lastException.getMessage();
        }
        return (String)str + e.toString();
    }
}

