/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.generator;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.ui.AF3ComponentUIActivator;
import org.fortiss.af3.component.ui.utils.FMUUtils;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.utils.DataDictionaryUtils;
import org.fortiss.af3.generator.common.AF3GeneratorCommonActivator;
import org.fortiss.af3.generator.common.model.fmu.FMUArchivePackage;
import org.fortiss.af3.generator.common.model.fmu.FMUConfiguration;
import org.fortiss.af3.generator.common.model.source.AbstractUnit;
import org.fortiss.af3.generator.common.textgen.c.FMUModelDescriptionTextGenerator;
import org.fortiss.af3.generator.common.textgen.c.FMUTopCEntryTextGenerator;
import org.fortiss.af3.project.extension.base.ExecutionTargetBase;
import org.fortiss.af3.project.extension.data.Executable;
import org.fortiss.af3.project.model.execution.ExecutionConfiguration;
import org.fortiss.af3.project.model.execution.ExecutionConfigurationPart;
import org.fortiss.af3.project.ui.utils.FolderOrProjectDialogUtils;
import org.fortiss.tooling.base.utils.SystemUtils;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.tooling.kernel.utils.ResourceUtils;

public class FMUGeneratorExecutionTarget
extends ExecutionTargetBase {
    private double lastSelectedFrequency = 100.0;
    private IFolder targetFolder;

    public String getName() {
        return "Single FMU generator";
    }

    public Class<?> getExecutableClass() {
        return FMUArchivePackage.class;
    }

    protected void doExecute(Executable executable) {
        if (SystemUtils.isMacOSXPlatform()) {
            MessageUtilsExtended.showErrorInUIThread((String)"No macOS support for this feature", (String)"Exporting a component as FMU is currently not supported on macOS.");
            return;
        }
        FMUArchivePackage fmuSource = (FMUArchivePackage)executable.getExecutableObject();
        ExecutionConfiguration executionConfiguration = executable.getConfiguration();
        DataDictionary dd = DataDictionaryUtils.findDataDictionary((EObject)((EObject)executable.getSource()));
        Double samplingTime = null;
        boolean isManuallyInvoked = false;
        Optional<ExecutionConfigurationPart> optionalFMUConfiguration = executionConfiguration.getConfigurationParts().stream().filter(e -> e instanceof FMUConfiguration).findFirst();
        if (optionalFMUConfiguration.isPresent()) {
            this.targetFolder = ((FMUConfiguration)optionalFMUConfiguration.get()).getDestinationFolder();
            fmuSource.setStepDuration(((FMUConfiguration)optionalFMUConfiguration.get()).getStepSize());
        } else {
            isManuallyInvoked = true;
            samplingTime = FMUUtils.getSamplingTime(dd, this.lastSelectedFrequency);
            this.targetFolder = FolderOrProjectDialogUtils.openFolderDialog();
            if (samplingTime == null || this.targetFolder == null) {
                return;
            }
            fmuSource.setStepDuration(samplingTime.doubleValue());
        }
        try {
            FileWriter writer22;
            String tempBuildDirectoryPath = Files.createTempDirectory("AF3_FMU_" + fmuSource.getModelDescription().getName(), new FileAttribute[0]).toString();
            fmuSource.getCSource().writeContentToLocation(tempBuildDirectoryPath);
            Throwable throwable = null;
            Throwable throwable2 = null;
            try {
                writer22 = new FileWriter(new File(tempBuildDirectoryPath, "modelDescription.xml"));
                try {
                    writer22.write(FMUModelDescriptionTextGenerator.fmuArchiveToXML((FMUArchivePackage)fmuSource));
                }
                finally {
                    if (writer22 != null) {
                        writer22.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            File targetTopCFile = new File(tempBuildDirectoryPath, "fmuTopEntry.c");
            throwable2 = null;
            writer22 = null;
            try (FileWriter writer = new FileWriter(targetTopCFile);){
                writer.write(FMUTopCEntryTextGenerator.fmuArchiveToTopCEntry((FMUArchivePackage)fmuSource));
            }
            catch (Throwable writer22) {
                if (throwable2 == null) {
                    throwable2 = writer22;
                } else if (throwable2 != writer22) {
                    throwable2.addSuppressed(writer22);
                }
                throw throwable2;
            }
            String fmiLibRelativePath = ResourceUtils.getResourceURI((String)AF3GeneratorCommonActivator.PLUGIN_ID, (String)"/lib/FMILibrary-2.0.2-win32/include");
            String fmiLibPath = FileLocator.resolve((URL)new URL(fmiLibRelativePath)).getPath().substring(1);
            Object[] src = this.collectSourceFiles(fmuSource, "src-gen/", "c");
            String[] compileCommand = (String[])ArrayUtils.addAll((Object[])this.getGccCommandAndPath(fmiLibPath), (Object[])src);
            int exitCode = this.runCommand(compileCommand, tempBuildDirectoryPath);
            if (exitCode != 0) {
                throw new RuntimeException("[FMI export] the compiler failed on compilation. Exit code: " + exitCode);
            }
            Object[] obj = this.collectSourceFiles(fmuSource, "", "o");
            Object[] temp = new String[]{"gcc", "-shared", "-o", fmuSource.getModelDescription().getName() + this.getLibraryExtension()};
            String[] linkCommand = (String[])ArrayUtils.addAll((Object[])temp, (Object[])obj);
            exitCode = this.runCommand(linkCommand, tempBuildDirectoryPath);
            if (exitCode != 0) {
                throw new RuntimeException("[FMI export] the compiler failed on linking. Exit code: " + exitCode);
            }
            this.makeZip(fmuSource, this.targetFolder.getLocation().toOSString(), tempBuildDirectoryPath);
            FileUtils.deleteDirectory((File)new File(tempBuildDirectoryPath));
        }
        catch (IOException ioex) {
            throw new RuntimeException("[FMI export] I/O error: " + ioex.getMessage());
        }
        catch (InterruptedException ioex) {
            throw new RuntimeException("[FMI export] Interrupt error: " + ioex.getMessage());
        }
        try {
            this.targetFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException cex) {
            LoggingUtils.error((Plugin)AF3ComponentUIActivator.getDefault(), (String)cex.getMessage(), (Throwable)cex);
        }
        if (isManuallyInvoked) {
            MessageUtilsExtended.showInfoInUIThread((String)"[Success: FMI export]", (String)(fmuSource.getModelDescription().getName() + ".fmu was successfuly generated!"));
        }
    }

    private String getLibraryExtension() {
        String ext = null;
        ext = SystemUtils.isWindowsPlatform() ? ".dll" : ".so";
        return ext;
    }

    private String[] getGccCommandAndPath(String fmiLibPath) {
        String[] path = null;
        path = SystemUtils.isWindowsPlatform() ? new String[]{"gcc", "-w", "-I" + fmiLibPath, "-iquote.", "-c"} : new String[]{"gcc", "-fPIC", "-I/" + fmiLibPath, "-iquote.", "-c"};
        return path;
    }

    private String[] collectSourceFiles(FMUArchivePackage fmuSource, String prefix, String extension) {
        ArrayList<CallSite> src = new ArrayList<CallSite>();
        for (AbstractUnit unit : fmuSource.getCSource().getSrcGenPackage().getUnits()) {
            src.add((CallSite)((Object)(prefix + unit.getName().substring(0, unit.getName().length() - 1) + extension)));
        }
        src.add((CallSite)((Object)("fmuTopEntry." + extension)));
        String[] srcArray = new String[src.size()];
        return src.toArray(srcArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void makeZip(FMUArchivePackage fmuSource, String targetLocation, String srcLocation) throws IOException {
        File baseFolder = new File(targetLocation);
        if (!baseFolder.exists()) {
            baseFolder.mkdirs();
        }
        String fmuName = fmuSource.getModelDescription().getName();
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            FileOutputStream dest = new FileOutputStream(baseFolder.toString() + File.separator + fmuName + ".fmu");
            try {
                try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));){
                    out.setMethod(8);
                    out.putNextEntry(new ZipEntry("modelDescription.xml"));
                    FMUGeneratorExecutionTarget.writeEntryToZip("modelDescription.xml", srcLocation, out);
                    out.putNextEntry(new ZipEntry("sources" + File.separator + "fmuTopEntry.c"));
                    FMUGeneratorExecutionTarget.writeEntryToZip("fmuTopEntry.c", srcLocation, out);
                    out.putNextEntry(new ZipEntry("binaries" + File.separator + FMUGeneratorExecutionTarget.getSystemIdentifier() + File.separator + fmuName + this.getLibraryExtension()));
                    FMUGeneratorExecutionTarget.writeEntryToZip(fmuName + this.getLibraryExtension(), srcLocation, out);
                    FMUGeneratorExecutionTarget.addSourceFilesInFMU(new File(srcLocation + "/src-gen"), out);
                    FMUGeneratorExecutionTarget.addSourceFilesInFMU(new File(srcLocation + "/inc-gen"), out);
                    FMUGeneratorExecutionTarget.addSourceFilesInFMU(new File(srcLocation + "/src"), out);
                    FMUGeneratorExecutionTarget.addSourceFilesInFMU(new File(srcLocation + "/inc"), out);
                    out.close();
                }
                if (dest == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (dest == null) throw throwable;
                dest.close();
                throw throwable;
            }
            dest.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static String getSystemIdentifier() {
        Object identifier = SystemUtils.isWindowsPlatform() ? "win" : "linux";
        identifier = (String)identifier + (SystemUtils.isOs64BitArch() ? "64" : "32");
        return identifier;
    }

    static void addSourceFilesInFMU(File dirObj, ZipOutputStream out) throws IOException {
        File[] files = dirObj.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                FMUGeneratorExecutionTarget.addSourceFilesInFMU(files[i], out);
            } else {
                out.putNextEntry(new ZipEntry("sources" + File.separator + files[i].getName()));
                FMUGeneratorExecutionTarget.writeEntryToZip(files[i].getName(), dirObj.getAbsolutePath(), out);
            }
            ++i;
        }
    }

    private static void writeEntryToZip(String fileName, String location, ZipOutputStream out) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream in = new FileInputStream(location + File.separator + fileName);){
            int len;
            byte[] data = new byte[1024];
            while ((len = in.read(data)) > 0) {
                out.write(data, 0, len);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private int runCommand(String[] command, String directory) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(command, null, new File(directory));
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        threadPool.invokeAll(Arrays.asList(new InputStreamConsumer(p.getInputStream()), new InputStreamConsumer(p.getErrorStream())));
        return p.waitFor();
    }

    public IFolder getTargetFolder() {
        return this.targetFolder;
    }

    private static final class InputStreamConsumer
    implements Callable<List<String>> {
        InputStream s;

        public InputStreamConsumer(InputStream s) {
            this.s = s;
        }

        @Override
        public List<String> call() throws Exception {
            Stream<String> lines = new BufferedReader(new InputStreamReader(this.s)).lines();
            lines.forEach(l -> System.out.println(l + "\n"));
            return lines.collect(Collectors.toList());
        }
    }
}

