/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.generator;

import com.google.common.collect.Streams;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.ui.generator.FMUGeneratorExecutionTarget;
import org.fortiss.af3.component.ui.utils.FMUUtils;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.utils.DataDictionaryUtils;
import org.fortiss.af3.generator.common.model.fmu.AF3GeneratorCommonFMUFactory;
import org.fortiss.af3.generator.common.model.fmu.FMUArchivePackage;
import org.fortiss.af3.generator.common.model.fmu.FMUConfiguration;
import org.fortiss.af3.generator.common.model.fmu.FMUConnection;
import org.fortiss.af3.generator.common.model.fmu.FMUMultiArchivePackage;
import org.fortiss.af3.generator.common.model.fmu.IFMUVariable;
import org.fortiss.af3.project.extension.IExecutionTarget;
import org.fortiss.af3.project.extension.base.ExecutionTargetBase;
import org.fortiss.af3.project.extension.data.Executable;
import org.fortiss.af3.project.extension.exception.ExecutionFailedException;
import org.fortiss.af3.project.model.execution.ExecutionConfiguration;
import org.fortiss.af3.project.services.IExecutionService;
import org.fortiss.af3.project.ui.utils.FolderOrProjectDialogUtils;
import org.fortiss.af3.project.utils.ProjectModelElementFactory;
import org.fortiss.tooling.base.utils.SystemUtils;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;

public class FMUMultiGeneratorExecutionTarget
extends ExecutionTargetBase {
    private double lastSelectedFrequency = 100.0;
    private IFolder targetFolder;

    public String getName() {
        return "Multiple FMU generator";
    }

    public Class<?> getExecutableClass() {
        return FMUMultiArchivePackage.class;
    }

    protected void doExecute(Executable executable) {
        if (SystemUtils.isMacOSXPlatform()) {
            MessageUtilsExtended.showErrorInUIThread((String)"No macOS support for this feature", (String)"Exporting a component as FMU is currently not supported on macOS.");
            return;
        }
        FMUMultiArchivePackage fmuPackage = (FMUMultiArchivePackage)executable.getExecutableObject();
        DataDictionary dd = DataDictionaryUtils.findDataDictionary((EObject)((EObject)executable.getSource()));
        this.targetFolder = FolderOrProjectDialogUtils.openFolderDialog();
        if (this.targetFolder == null) {
            return;
        }
        Double samplingTime = FMUUtils.getSamplingTime(dd, this.lastSelectedFrequency);
        if (samplingTime == null) {
            return;
        }
        FMUGeneratorExecutionTarget executor = (FMUGeneratorExecutionTarget)IExecutionService.INSTANCE.getSpecificExecutionTarget(FMUGeneratorExecutionTarget.class);
        ExecutionConfiguration executionConfiguration = ProjectModelElementFactory.createExecutionConfiguration();
        FMUConfiguration fmuConfiguration = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMUConfiguration();
        fmuConfiguration.setDestinationFolder(this.targetFolder);
        fmuConfiguration.setStepSize(samplingTime.doubleValue());
        executionConfiguration.getConfigurationParts().add((Object)fmuConfiguration);
        try {
            for (FMUArchivePackage slavePackage : fmuPackage.getSlaves()) {
                new Executable(null, (IExecutionTarget)executor, executionConfiguration, (Object)slavePackage).execute();
            }
        }
        catch (ExecutionFailedException e) {
            MessageUtilsExtended.showErrorInUIThread((String)"Error occured", (String)("The following I/O Error occured while trying to export the subcomponents as FMU: " + e.getMessage()));
        }
        this.writeCoSimulationConfiguration(fmuPackage, fmuConfiguration);
    }

    private void writeCoSimulationConfiguration(FMUMultiArchivePackage fmuPackage, FMUConfiguration fmuConfiguration) {
        String fmus = this.getCosimulationFMUsAsJSON(fmuPackage);
        String incoming = this.getIncomingConnectionsAsJSON(fmuPackage);
        String outgoing = this.getOutgoingConnectionsAsJSON(fmuPackage);
        String connections = this.getInternalConnectionsAsJSON(fmuPackage);
        StringBuffer config = new StringBuffer();
        config.append("{\n");
        config.append("\"connections\": {\n");
        config.append("\"external\": {\n");
        config.append("\"incoming\": [\n");
        config.append(incoming);
        config.append("],\n");
        config.append("\"outgoing\": [\n");
        config.append(outgoing);
        config.append("]\n");
        config.append("},\n");
        config.append("\"internal\": [\n");
        config.append(connections);
        config.append("]\n");
        config.append("},\n");
        config.append("\"fmus\": [\n");
        config.append(fmus);
        config.append("],\n");
        config.append("\"settings\": {\n");
        config.append("\"fmuStepSize\": 0.01,\n \"updateSize\": 0.1\n");
        config.append("}\n");
        config.append("}\n");
        String targetLocation = fmuConfiguration.getDestinationFolder().getLocation().toOSString();
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (FileWriter writer = new FileWriter(new File(targetLocation, "config.json"));){
                writer.write(config.toString());
                MessageUtilsExtended.showInfoInUIThread((String)"Success", (String)"Successfully created the configuration file for the ROS FMU adapter (master) and the FMUs for the subcomponents");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioex) {
            MessageUtilsExtended.showErrorInUIThread((String)"Error occured", (String)("The following I/O Error occured while trying to export the config: " + ioex.getMessage()));
        }
    }

    private String getCosimulationFMUsAsJSON(FMUMultiArchivePackage fmuPackage) {
        StringBuffer buf = new StringBuffer();
        for (FMUArchivePackage fmuSlave : fmuPackage.getSlaves()) {
            buf.append("{\n");
            String name = fmuSlave.getModelDescription().getName();
            buf.append("\"file\": \"" + name + ".fmu\",\n \"name\": \"" + name + "\"\n");
            buf.append("},\n");
        }
        if (fmuPackage.getSlaves().size() > 0) {
            buf.deleteCharAt(buf.length() - ",\n".length());
        }
        return buf.toString();
    }

    private String getInternalConnectionsAsJSON(FMUMultiArchivePackage fmuPackage) {
        StringBuffer buf = new StringBuffer();
        for (FMUConnection connection : fmuPackage.getSlaveConnections()) {
            buf.append("{\n");
            buf.append("\"source\": \"" + this.encodeVariable(fmuPackage, connection.getSource()) + "\",");
            buf.append("\"sink\": ");
            StringBuffer innerBuf = new StringBuffer();
            innerBuf.append("[\n");
            for (IFMUVariable sink : connection.getSinks()) {
                innerBuf.append("\"" + this.encodeVariable(fmuPackage, sink) + "\",\n");
            }
            if (connection.getSinks().size() > 0) {
                innerBuf.deleteCharAt(innerBuf.length() - ",\n".length());
            }
            innerBuf.append("]\n");
            buf.append(innerBuf);
            buf.append("},\n");
        }
        if (fmuPackage.getSlaveConnections().size() > 0) {
            buf.deleteCharAt(buf.length() - ",\n".length());
        }
        return buf.toString();
    }

    private String getIncomingConnectionsAsJSON(FMUMultiArchivePackage fmuPackage) {
        StringBuffer buf = new StringBuffer();
        for (IFMUVariable incoming : fmuPackage.getIncomingConnections()) {
            buf.append("{\n");
            buf.append("\"name\": \"" + incoming.getName() + "\",\n");
            buf.append("\"sink\": \"" + this.encodeVariable(fmuPackage, incoming) + "\"");
            buf.append("},\n");
        }
        if (fmuPackage.getIncomingConnections().size() > 0) {
            buf.deleteCharAt(buf.length() - ",\n".length());
        }
        return buf.toString();
    }

    private String getOutgoingConnectionsAsJSON(FMUMultiArchivePackage fmuPackage) {
        StringBuffer buf = new StringBuffer();
        for (IFMUVariable outgoing : fmuPackage.getOutgoingConnections()) {
            buf.append("{\n");
            buf.append("\"name\": \"" + outgoing.getName() + "\",\n");
            buf.append("\"source\": \"" + this.encodeVariable(fmuPackage, outgoing) + "\"");
            buf.append("},\n");
        }
        if (fmuPackage.getOutgoingConnections().size() > 0) {
            buf.deleteCharAt(buf.length() - ",\n".length());
        }
        return buf.toString();
    }

    private String encodeVariable(FMUMultiArchivePackage fmuPackage, IFMUVariable fmuVariable) {
        FMUArchivePackage fmuArchive = fmuPackage.getSlaves().stream().filter(slave -> Streams.concat((Stream[])new Stream[]{slave.getInputs().stream(), slave.getOutputs().stream()}).anyMatch(variable -> variable == fmuVariable)).findAny().get();
        return fmuArchive.getModelDescription().getName() + "." + fmuVariable.getName();
    }

    public IFolder getTargetFolder() {
        return this.targetFolder;
    }
}

