/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.generator;

import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.fortiss.af3.component.ui.AF3ComponentUIActivator;
import org.fortiss.af3.generator.common.model.java.JavaSourcePackage;
import org.fortiss.af3.project.extension.base.ExecutionTargetBase;
import org.fortiss.af3.project.extension.data.Executable;
import org.fortiss.af3.project.ui.utils.FolderOrProjectDialogUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class JavaGeneratorExecutionTarget
extends ExecutionTargetBase {
    public String getName() {
        return "Java Code Generator";
    }

    public Class<?> getExecutableClass() {
        return JavaSourcePackage.class;
    }

    protected void doExecute(Executable executable) {
        JavaSourcePackage javaSource = (JavaSourcePackage)executable.getExecutableObject();
        IFolder targetFolder = FolderOrProjectDialogUtils.openFolderDialog();
        if (targetFolder == null) {
            return;
        }
        try {
            javaSource.writeContentToLocation(targetFolder.getLocation().toOSString());
        }
        catch (IOException ioex) {
            LoggingUtils.error((Plugin)AF3ComponentUIActivator.getDefault(), (String)ioex.getMessage(), (Throwable)ioex);
        }
        try {
            targetFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException cex) {
            LoggingUtils.error((Plugin)AF3ComponentUIActivator.getDefault(), (String)cex.getMessage(), (Throwable)cex);
        }
    }
}

