/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.collections.Pair;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.PortSpecification;
import org.fortiss.af3.component.model.PropagatableSpecification;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.af3.component.utils.ComponentUtils;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IModelEditor;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

class PortDataPropagation
implements SelectionListener {
    protected TabbedPropertySheetWidgetFactory widgetFactory;
    protected Composite targetComposite;
    protected PortDataAccess portDataAccess;
    protected Button propagateForward;
    protected Button propagateBackward;
    private List<Pair<Channel, Port>> portsToPropagate;

    public PortDataPropagation(TabbedPropertySheetWidgetFactory widgetFactory, Composite targetComposite, PortDataAccess portDataAccess) {
        this.widgetFactory = widgetFactory;
        this.targetComposite = targetComposite;
        this.portDataAccess = portDataAccess;
    }

    public static Composite newPropagationComposite(TabbedPropertySheetWidgetFactory widgetFactory, Composite targetComposite, PortDataAccess portDataAccess) {
        PortDataPropagation propagation = new PortDataPropagation(widgetFactory, targetComposite, portDataAccess);
        return propagation.createPropagationControls();
    }

    public Composite createPropagationControls() {
        Composite propagate = this.widgetFactory.createComposite(this.targetComposite);
        propagate.setLayout((Layout)new FillLayout(256));
        this.propagateBackward = this.widgetFactory.createButton(propagate, "<- backward", 8);
        this.propagateBackward.addSelectionListener((SelectionListener)this);
        this.propagateForward = this.widgetFactory.createButton(propagate, "forward ->", 8);
        this.propagateForward.addSelectionListener((SelectionListener)this);
        return propagate;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.portDataAccess.getPortSpecification());
        topLevel.runAsCommand(new Runnable(){

            @Override
            public void run() {
                for (Pair<Channel, Port> c : PortDataPropagation.this.portsToPropagate) {
                    PortDataPropagation.this.propagatePropagatableSpecs((Channel)c.getFirst(), (Port)c.getSecond());
                }
            }
        });
    }

    public void addSelectionListenerToPropagateControls(SelectionListener listener) {
        this.propagateBackward.addSelectionListener(listener);
        this.propagateForward.addSelectionListener(listener);
    }

    private void propagatePropagatableSpecs(Channel c, Port destPort) {
        EList<IModelElementSpecification> srcSpecs = this.portDataAccess.getSpecifications();
        EList destSpecs = destPort.getSpecifications();
        for (IModelElementSpecification srcSpec : srcSpecs) {
            IModelElementSpecification destSpec = (IModelElementSpecification)EcoreUtils.pickFirstInstanceOf(srcSpec.getClass(), (List)destSpecs);
            if (destSpec == null || !(srcSpec instanceof PropagatableSpecification) || !(destSpec instanceof PropagatableSpecification)) continue;
            ((PropagatableSpecification)srcSpec).propagate((PropagatableSpecification)destSpec);
        }
        PortSpecification src = this.portDataAccess.getPortSpecification();
        PortSpecification dest = destPort.getPortSpecification();
        this.portDataAccess.copyNonSpecificationData(src, dest);
        this.portDataAccess.adjustChannelData(c, src, dest);
    }

    public void enableControls(Boolean enabled) {
        this.propagateBackward.getParent().setEnabled(enabled.booleanValue());
        this.propagateBackward.setEnabled(enabled.booleanValue());
        this.propagateForward.setEnabled(enabled.booleanValue());
    }

    public static List<Pair<Channel, Port>> getPortsToPropagate(Port port, IWorkbenchPart part) {
        ArrayList<Pair<Channel, Port>> res = new ArrayList<Pair<Channel, Port>>();
        boolean seenAsSrc = PortDataPropagation.seenAsSource(port, part);
        EList channels = seenAsSrc ? port.getOutgoingChannels() : port.getIncomingChannels();
        for (Channel c : channels) {
            Port otherPort = seenAsSrc ? c.getTarget() : c.getSource();
            res.add((Pair<Channel, Port>)new Pair((Object)c, (Object)otherPort));
        }
        return res;
    }

    private static boolean seenAsSource(Port port, IWorkbenchPart part) {
        boolean seenAsSrc = port instanceof InputPort;
        seenAsSrc = port.getComponent().equals(PortDataPropagation.getEditedComponent(part)) ? seenAsSrc : !seenAsSrc;
        return seenAsSrc;
    }

    private static Component getEditedComponent(IWorkbenchPart part) {
        if (!(part instanceof IModelEditor)) {
            return null;
        }
        EObject editedObj = ((IModelEditor)part).getEditedObject();
        return ComponentUtils.componentOf((EObject)editedObj);
    }

    public void refresh(Port port) {
        this.portsToPropagate = PortDataPropagation.getPortsToPropagate(port, this.portDataAccess.getPart());
        if (this.isPortComponentHasExternalSpecification(port).booleanValue()) {
            if (PortDataPropagation.seenAsSource(port, this.portDataAccess.getPart())) {
                this.propagateBackward.setEnabled(false);
                this.propagateForward.setEnabled(!this.portsToPropagate.isEmpty());
            } else {
                this.propagateBackward.setEnabled(!this.portsToPropagate.isEmpty());
                this.propagateForward.setEnabled(false);
            }
        }
    }

    private Boolean isPortComponentHasExternalSpecification(Port port) {
        this.propagateForward.setEnabled(false);
        this.propagateBackward.setEnabled(false);
        boolean checkPortOut = true;
        EList channelsOut = port.getOutgoingChannels();
        EList channelsIn = port.getIncomingChannels();
        if (!channelsOut.isEmpty()) {
            for (Channel ch : channelsOut) {
                Component targetComponent = ch.getTarget().getComponent();
                if (!ComponentArchitectureUtils.hasReadOnlyBehaviorSpecification((Component)targetComponent)) continue;
                checkPortOut = false;
            }
        } else {
            checkPortOut = false;
        }
        this.propagateForward.setEnabled(checkPortOut && PortDataPropagation.seenAsSource(port, this.portDataAccess.getPart()));
        boolean checkPortIn = true;
        if (!channelsIn.isEmpty()) {
            for (Channel ch : channelsIn) {
                Component sourceComponent = ch.getSource().getComponent();
                if (!ComponentArchitectureUtils.hasReadOnlyBehaviorSpecification((Component)sourceComponent)) continue;
                checkPortIn = false;
            }
        } else {
            checkPortIn = false;
        }
        this.propagateBackward.setEnabled(checkPortIn && !PortDataPropagation.seenAsSource(port, this.portDataAccess.getPart()));
        if (checkPortOut && checkPortIn) {
            return true;
        }
        return false;
    }

    public static interface PortDataAccess {
        public EList<IModelElementSpecification> getSpecifications();

        public PortSpecification getPortSpecification();

        public Port getPort();

        public IWorkbenchPart getPart();

        public void copyNonSpecificationData(PortSpecification var1, PortSpecification var2);

        public void adjustChannelData(Channel var1, PortSpecification var2, PortSpecification var3);
    }
}

