/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.properties;

import java.util.function.Function;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.component.model.AF3ComponentPackage;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.PortSpecification;
import org.fortiss.af3.component.ui.utils.ComponentCompletionProposalUtils;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.types.TBool;
import org.fortiss.af3.expression.model.types.TDouble;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.expression.ui.complexdata.ComplexDataDialog;
import org.fortiss.af3.expression.ui.complexdata.ComplexDataDialogButtonEnableListener;
import org.fortiss.af3.expression.ui.databinding.convert.ITermToStringConverter;
import org.fortiss.af3.expression.ui.databinding.convert.StringToIExpressionTermConverter;
import org.fortiss.af3.expression.ui.databinding.validate.StringToBooleanConstValidator;
import org.fortiss.af3.expression.ui.databinding.validate.StringToDoubleConstValidator;
import org.fortiss.af3.expression.ui.databinding.validate.StringToIExpressionTermValidator;
import org.fortiss.af3.expression.ui.databinding.validate.StringToIntConstValidator;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.base.ui.fieldassist.FieldAssist;
import org.fortiss.tooling.base.ui.fieldassist.IProposalProvider;
import org.fortiss.tooling.base.ui.fieldassist.ProposalProviderBase;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;
import org.fortiss.tooling.kernel.ui.util.DataBindingUtils;
import org.fortiss.tooling.kernel.ui.util.ObservableUtils;

public class PortInitValueSection
extends PropertySectionBase {
    private Port port;
    private PortSpecification spec;
    private final String initValStr = "Initial value";
    private Text initialValueText;
    private Button structInitHelperButton;
    private ComplexDataDialogButtonEnableListener buttonEnabler;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.initialValueText = this.createDecoratedFormText("Initial value", 2626);
        this.structInitHelperButton = this.createDecoratedButton("...", (Control)this.initialValueText);
        this.structInitHelperButton.addSelectionListener(e -> this.openComplexDataDialog());
        this.buttonEnabler = new ComplexDataDialogButtonEnableListener(null, (Control)this.structInitHelperButton);
        new FieldAssist(this.initialValueText, (IProposalProvider)PortInitValueSection.mkPP(word -> ComponentCompletionProposalUtils.createInitialValueProposals(this.spec)));
        this.composite.pack();
    }

    protected void setSectionInput(Object input) {
        if (input instanceof Port) {
            this.port = (Port)input;
            this.spec = this.port.getPortSpecification();
            this.buttonEnabler.listenTo((EObject)this.spec, (EStructuralFeature)AF3ComponentPackage.Literals.PORT_SPECIFICATION__TYPE);
        } else {
            this.buttonEnabler.unlisten();
            this.port = null;
            this.spec = null;
        }
    }

    public void refresh() {
        super.refresh();
        if (this.port.getComponent() == null) {
            return;
        }
        IObservableValue initValue = ObservableUtils.observeValue((EObject)this.spec, (EStructuralFeature)AF3ComponentPackage.Literals.PORT_SPECIFICATION__INITIAL_VALUE);
        ITermToStringConverter modelToTextConverter = new ITermToStringConverter();
        StringToIExpressionTermConverter textToModelConverter = new StringToIExpressionTermConverter((EObject)this.spec);
        StringToIExpressionTermValidator textValidator = new StringToIExpressionTermValidator((EObject)this.spec);
        IType type = this.spec.getType();
        if (type instanceof TInt) {
            textValidator = new StringToIntConstValidator((EObject)this.spec);
        }
        if (type instanceof TDouble) {
            textValidator = new StringToDoubleConstValidator((EObject)this.spec);
        }
        if (type instanceof TBool) {
            textValidator = new StringToBooleanConstValidator((EObject)this.spec);
        }
        DataBindingUtils.performComplexTextBinding((DataBindingContext)this.dbc, (Control)this.initialValueText, (IObservableValue)initValue, (IConverter)modelToTextConverter, (IConverter)textToModelConverter, (IValidator)textValidator, null);
        boolean isStronglyCausal = this.port.getComponent().isStronglyCausal();
        boolean isReadOnly = ComponentArchitectureUtils.hasReadOnlyBehaviorSpecification((Component)this.port.getComponent());
        boolean isEnabled = isStronglyCausal && this.port instanceof OutputPort && !isReadOnly;
        this.initialValueText.setEnabled(isEnabled);
    }

    public void dispose() {
        super.dispose();
        if (this.buttonEnabler != null) {
            this.buttonEnabler.dispose();
        }
    }

    private void openComplexDataDialog() {
        IType specType = this.spec.getType();
        final IExpressionTerm initialValue = ComplexDataDialog.openCDD((Shell)this.composite.getShell(), (EMFDataBindingContext)this.dbc, (String)"Initial value", (String)specType.toString(), (EObject)this.spec, (IType)specType, (IExpressionTerm)this.spec.getInitialValue(), (boolean)true);
        if (initialValue != null) {
            ICommandStackService.getInstance().runAsCommand((EObject)this.spec, new Runnable(){

                @Override
                public void run() {
                    PortInitValueSection.this.spec.setInitialValue(initialValue);
                }
            });
        }
        this.refresh();
    }

    private static ProposalProviderBase mkPP(final Function<String, String[]> provider) {
        return new ProposalProviderBase(){

            public String[] getProposals(String currentWord) {
                return (String[])provider.apply(currentWord);
            }
        };
    }

    @FunctionalInterface
    private static interface SSL
    extends SelectionListener {
        default public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

