/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.component.AF3ComponentActivator;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.PortSpecification;
import org.fortiss.af3.component.ui.AF3ComponentUIActivator;
import org.fortiss.af3.component.ui.properties.PortDataPropagation;
import org.fortiss.af3.component.ui.properties.TypeLabelProvider;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.expression.utils.ExpressionUtils;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;
import org.fortiss.tooling.kernel.ui.service.IModelEditorBindingService;
import org.fortiss.tooling.kernel.ui.util.WidgetsFactory;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public final class PortSpecificationPropertySection
extends PropertySectionBase
implements PortDataPropagation.PortDataAccess {
    private boolean userInput;
    private Port port;
    private PortSpecification spec;
    private ITopLevelElement topLevel;
    private ComboViewer typeComboViewer;
    private PortDataPropagation propagate;
    private Button goToTypeButton;
    private Composite variableBounds;
    private Text upperBound;
    private Text lowerBound;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.typeComboViewer = this.createDecoratedComboViewer("Type");
        this.typeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeComboViewer.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        this.typeComboViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return PortSpecificationPropertySection.compareTypes(e1, e2);
            }
        });
        this.goToTypeButton = this.getWidgetFactory().createButton(this.composite, "Go to type", 8);
        this.createFormEntry((Control)this.goToTypeButton, "");
        GridDataFactory.defaultsFor((Control)this.goToTypeButton).align(1, 1).applyTo((Control)this.goToTypeButton);
        this.goToTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PortSpecificationPropertySection.this.goToType();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.typeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (PortSpecificationPropertySection.this.userInput) {
                    PortSpecificationPropertySection.this.topLevel.runAsCommand(new Runnable(){

                        @Override
                        public void run() {
                            PortSpecificationPropertySection.this.typeSelectionChangeHandler();
                        }
                    });
                }
            }
        });
        this.propagate = new PortDataPropagation(this.getWidgetFactory(), this.composite, this);
        this.createFormEntry((Control)this.propagate.createPropagationControls(), "Propagate data");
        this.variableBounds = this.getWidgetFactory().createComposite(this.composite);
        this.variableBounds.setLayout((Layout)new GridLayout(3, false));
        this.lowerBound = WidgetsFactory.createText((Composite)this.variableBounds, (int)2048, (String)"", (int)6);
        this.getWidgetFactory().createLabel(this.variableBounds, "...");
        this.lowerBound.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!(PortSpecificationPropertySection.this.spec.getType() instanceof TInt)) {
                    return;
                }
                PortSpecificationPropertySection.this.topLevel.runAsCommand(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).PortSpecificationPropertySection.this.spec.getType() instanceof TInt) {
                            PortSpecificationPropertySection.this.boundHandler((this).PortSpecificationPropertySection.this.lowerBound, arg_0 -> ((TInt)((TInt)(this).PortSpecificationPropertySection.this.spec.getType())).setLowerBound(arg_0));
                        }
                    }
                });
            }
        });
        this.upperBound = WidgetsFactory.createText((Composite)this.variableBounds, (int)2048, (String)"", (int)6);
        this.upperBound.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!(PortSpecificationPropertySection.this.spec.getType() instanceof TInt)) {
                    return;
                }
                PortSpecificationPropertySection.this.topLevel.runAsCommand(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).PortSpecificationPropertySection.this.spec.getType() instanceof TInt) {
                            PortSpecificationPropertySection.this.boundHandler((this).PortSpecificationPropertySection.this.upperBound, arg_0 -> ((TInt)((TInt)(this).PortSpecificationPropertySection.this.spec.getType())).setUpperBound(arg_0));
                        }
                    }
                });
            }
        });
        this.createFormEntry((Control)this.variableBounds, "Port Bounds:");
    }

    private void goToType() {
        IStructuredSelection selection = (IStructuredSelection)this.typeComboViewer.getSelection();
        IType selectedType = (IType)selection.getFirstElement();
        if (selectedType instanceof TDefinedType) {
            TypeDefinition def = ((TDefinedType)selectedType).getDef();
            IModelEditorBindingService.getInstance().openInEditor((EObject)def);
        }
    }

    private void boundHandler(Text text, Consumer<Integer> boundSetter) {
        if (this.spec.getType() instanceof TInt) {
            Integer boundValue;
            try {
                boundValue = Integer.parseInt(text.getText());
            }
            catch (NumberFormatException e) {
                boundValue = null;
            }
            if (boundValue != null) {
                boundSetter.accept(boundValue);
            }
        }
    }

    private void typeSelectionChangeHandler() {
        IStructuredSelection selection = (IStructuredSelection)this.typeComboViewer.getSelection();
        IType selectedType = (IType)selection.getFirstElement();
        if (!PortSpecificationPropertySection.typesAreEqual(selectedType, this.spec.getType())) {
            this.spec.setType((IType)EcoreUtils.copy((EObject)selectedType));
        }
        this.refreshBoundsControls();
        this.refreshGotoTypeButton();
    }

    public void refresh() {
        super.refresh();
        if (this.spec == null || this.port.getComponent() == null) {
            return;
        }
        this.refreshGotoTypeButton();
        this.refreshBoundsControls();
        this.userInput = false;
        List types = new ArrayList<IType>();
        types.add(this.spec.getType());
        if (!ComponentArchitectureUtils.hasReadOnlyBehaviorSpecification((Component)this.port.getComponent())) {
            types = ExpressionUtils.getAllVisibleTypes((EObject)this.spec);
        }
        this.typeComboViewer.setInput(types);
        this.typeComboViewer.setSelection((ISelection)new StructuredSelection(types.stream().filter(t -> PortSpecificationPropertySection.typesAreEqual(t, this.spec.getType())).collect(Collectors.toList())));
        this.userInput = true;
        this.propagate.refresh(this.port);
    }

    protected void setSectionInput(Object input) {
        if (input instanceof EObject) {
            this.topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)input);
        }
        if (input instanceof Port) {
            this.port = (Port)input;
            this.spec = ((Port)input).getPortSpecification();
        }
        if (this.spec == null) {
            LoggingUtils.error((Plugin)AF3ComponentUIActivator.getDefault(), (String)"PortSpecificationPropertySection input is null!");
        } else {
            try {
                this.refreshBoundsControls();
            }
            catch (ClassCastException ex) {
                LoggingUtils.error((Plugin)AF3ComponentActivator.getDefault(), (String)"The port parent component was not found.", (Throwable)ex);
            }
        }
    }

    private void refreshBoundsControls() {
        if (this.spec.getType() instanceof TInt) {
            TInt intType = (TInt)this.spec.getType();
            this.lowerBound.setText("" + intType.getLowerBound());
            this.upperBound.setText("" + intType.getUpperBound());
            if (ComponentArchitectureUtils.hasReadOnlyBehaviorSpecification((Component)this.port.getComponent())) {
                this.disableBoundControls();
            } else {
                this.enableBoundControls();
            }
        } else {
            this.upperBound.setText(" ");
            this.lowerBound.setText(" ");
            this.disableBoundControls();
        }
    }

    private void refreshGotoTypeButton() {
        boolean typeHasDefinition = false;
        if (this.spec.getType() instanceof TDefinedType) {
            TDefinedType definedType = (TDefinedType)this.spec.getType();
            typeHasDefinition = definedType.getDef() != null;
        }
        this.goToTypeButton.setEnabled(typeHasDefinition);
    }

    public void enableBoundControls() {
        this.lowerBound.setEnabled(true);
        this.upperBound.setEnabled(true);
    }

    public void disableBoundControls() {
        this.lowerBound.setEnabled(false);
        this.upperBound.setEnabled(false);
    }

    protected void disableControls() {
        super.disableControls();
        this.propagate.enableControls(!ComponentArchitectureUtils.hasReadOnlyBehaviorSpecification((Component)this.port.getComponent()));
    }

    @Override
    public void copyNonSpecificationData(PortSpecification spec, PortSpecification other) {
        Port port = (Port)spec.eContainer();
        Port otherPort = (Port)other.eContainer();
        otherPort.setName(port.getName());
        otherPort.setComment(port.getComment());
    }

    @Override
    public void adjustChannelData(Channel channel, PortSpecification spec, PortSpecification other) {
        Port port = (Port)spec.eContainer();
        channel.setName(port.getName());
    }

    private static boolean typesAreEqual(Object e1, Object e2) {
        return PortSpecificationPropertySection.compareTypes(e1, e2) == 0;
    }

    private static int compareTypes(Object e1, Object e2) {
        return ExpressionUtils.getNameForType((Object)e1).compareToIgnoreCase(ExpressionUtils.getNameForType((Object)e2));
    }

    @Override
    public PortSpecification getPortSpecification() {
        return this.port.getPortSpecification();
    }

    @Override
    public EList<IModelElementSpecification> getSpecifications() {
        return this.port.getSpecifications();
    }

    @Override
    public Port getPort() {
        return (Port)this.spec.eContainer();
    }
}

