/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.simulator;

import java.util.ArrayList;
import java.util.List;
import org.conqat.ide.commons.ui.dialog.MessageUtils;
import org.eclipse.ui.IPropertyListener;
import org.fortiss.af3.component.simulator.ExecutableComponent;
import org.fortiss.af3.component.simulator.ExecutionException;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;

public class SimulationManager {
    public static final int SIMULATED_COMPONENT_CHANGED_EVENT = 1;
    public static final int SIMULATION_PERFORMED_EVENT = 2;
    public static final int SIMULATION_ABOUT_TO_PERFORM_EVENT = 3;
    public static final int SIMULATION_INITIALIZED_EVENT = 4;
    public static final int SIMULATION_STEPPED_BACK_EVENT = 5;
    public static final int SIMULATION_REFRESH_EVENT = 6;
    public static final int SIMULATION_ABOUT_TO_STEP_BACK_EVENT = 7;
    private static final int DEFAULT_SPEED = 250;
    private static int customSpeed = 250;
    private boolean ignoreSpeedWarning = false;
    public static SimulationManager INSTANCE = new SimulationManager();
    private ExecutableComponent<? extends IModelElementSpecification> currentSimulation;
    private List<IPropertyListener> listeners = new ArrayList<IPropertyListener>();
    private boolean performingStep = false;
    private Thread simulationThread;
    private ExecutionException lastException;

    public void setCurrentSimulation(ExecutableComponent<? extends IModelElementSpecification> simulation) {
        this.currentSimulation = simulation;
        this.fireSimulationEvent(1);
        if (this.currentSimulation != null) {
            this.currentSimulation.initialize();
            this.fireSimulationEvent(4);
            this.fireSimulationEvent(6);
        }
    }

    public ExecutableComponent<? extends IModelElementSpecification> getCurrentSimulation() {
        return this.currentSimulation;
    }

    public synchronized void run() {
        if (this.simulationThread != null) {
            return;
        }
        this.simulationThread = new Thread("AF3 Simulation"){

            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    long startTime = System.currentTimeMillis();
                    if (!SimulationManager.this.performingStep) {
                        SimulationManager.this.performStep();
                    }
                    if (SimulationManager.this.lastException != null) break;
                    long remainingDelay = (long)customSpeed - (System.currentTimeMillis() - startTime);
                    if (remainingDelay > 0L) {
                        try {
                            1.sleep(remainingDelay);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    if (remainingDelay >= 0L || SimulationManager.this.ignoreSpeedWarning) continue;
                    SimulationManager.this.ignoreSpeedWarning = MessageUtilsExtended.askQuestionInUIThread((String)"Simulation Error", (String)"The length of the simulation step is too small. Do you want to continue?");
                    if (SimulationManager.this.ignoreSpeedWarning) continue;
                    SimulationManager.this.reset();
                }
                SimulationManager.this.showLastErrorMessage();
            }
        };
        this.simulationThread.start();
    }

    public void showLastErrorMessage() {
        if (this.lastException == null) {
            return;
        }
        this.lastException.printStackTrace();
        MessageUtils.showErrorAsync((String)"Simulation Error", (String)("Simulation was aborted: " + this.lastException.getMessage()));
    }

    public synchronized void pause() {
        if (this.simulationThread != null) {
            this.simulationThread.interrupt();
        }
        this.simulationThread = null;
        this.performingStep = false;
        this.fireSimulationEvent(2);
        this.fireSimulationEvent(6);
    }

    public synchronized void reset() {
        this.ignoreSpeedWarning = false;
        if (this.currentSimulation == null) {
            return;
        }
        this.pause();
        this.currentSimulation.initialize();
        this.currentSimulation.clearHistory();
        this.fireSimulationEvent(4);
        this.fireSimulationEvent(6);
    }

    public void setSpeed(int timeBetweenSteps) {
        customSpeed = timeBetweenSteps;
    }

    public int getSpeed() {
        return customSpeed;
    }

    public synchronized void shutdown() {
        if (this.simulationThread != null) {
            this.simulationThread.interrupt();
            try {
                this.simulationThread.join();
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public synchronized void performStep() {
        this.lastException = null;
        if (this.currentSimulation == null) {
            return;
        }
        this.fireSimulationEvent(3);
        this.performingStep = true;
        try {
            this.currentSimulation.backupState();
            this.currentSimulation.performStep();
        }
        catch (ExecutionException ex) {
            this.lastException = ex;
        }
        this.performingStep = false;
        this.fireSimulationEvent(2);
        this.fireSimulationEvent(6);
    }

    public synchronized void performStepBack() {
        this.lastException = null;
        if (this.currentSimulation == null) {
            return;
        }
        this.fireSimulationEvent(7);
        this.performingStep = true;
        try {
            this.currentSimulation.restoreState();
        }
        catch (ExecutionException ex) {
            this.lastException = ex;
        }
        this.performingStep = false;
        this.fireSimulationEvent(5);
        this.fireSimulationEvent(6);
    }

    public synchronized boolean isSimulationRunning() {
        return this.simulationThread != null;
    }

    public void addListener(IPropertyListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IPropertyListener listener) {
        this.listeners.remove(listener);
    }

    private void fireSimulationEvent(int eventID) {
        IPropertyListener[] iPropertyListenerArray = this.listeners.toArray(new IPropertyListener[0]);
        int n = iPropertyListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyListener l = iPropertyListenerArray[n2];
            l.propertyChanged((Object)this, eventID);
            ++n2;
        }
    }

    public ExecutableComponent<? extends IModelElementSpecification> findExecutableById(int id) {
        if (this.currentSimulation == null) {
            return null;
        }
        return this.findExecutableByIdInternal(this.currentSimulation, id);
    }

    private ExecutableComponent<? extends IModelElementSpecification> findExecutableByIdInternal(ExecutableComponent<? extends IModelElementSpecification> executable, int id) {
        if (executable.getModelElement().getId() == id) {
            return executable;
        }
        for (ExecutableComponent subExec : executable.getSubElements()) {
            ExecutableComponent<? extends IModelElementSpecification> result = this.findExecutableByIdInternal((ExecutableComponent<? extends IModelElementSpecification>)subExec, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void postRefreshEvent() {
        this.fireSimulationEvent(6);
    }

    public synchronized void delete() {
        this.pause();
        this.setCurrentSimulation(null);
    }
}

