/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.simulator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.ide.commons.ui.ui.WorkbenchUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.WorkbenchException;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.ui.AF3ComponentUIActivator;
import org.fortiss.af3.component.ui.simulator.SimulatorExecutionTarget;
import org.fortiss.af3.component.ui.simulatorfx.views.GraphicalStructureSimulationFXView;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.af3.project.extension.IExecutionTarget;
import org.fortiss.af3.project.services.IExecutionService;
import org.fortiss.af3.project.ui.AF3ProjectUIActivator;
import org.fortiss.af3.project.ui.execution.EasyStartMenuBase;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.service.INavigatorService;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class SimulatorEasyStartMenu
extends EasyStartMenuBase {
    public SimulatorEasyStartMenu() {
        super(SimulatorEasyStartMenu.getSimulatorTargetFromExecutionService());
    }

    private static IExecutionTarget getSimulatorTargetFromExecutionService() {
        return IExecutionService.INSTANCE.getSpecificExecutionTarget(SimulatorExecutionTarget.class);
    }

    public String getMenuSectionID() {
        return "bottommost";
    }

    protected boolean acceptSelection(INamedElement selection, ContextMenuContextProvider contextProvider) {
        return (selection instanceof ComponentArchitecture || selection instanceof Component) && INavigatorService.getInstance().isNavigatorView(contextProvider) && !ComponentArchitectureUtils.containsReadOnlyBehaviorSpecification((EObject)selection);
    }

    protected String getActionName() {
        return "Run Simulator";
    }

    protected ImageDescriptor getActionIcon() {
        return AF3ProjectUIActivator.getImageDescriptor((String)"icons/execution_configuration.gif");
    }

    protected String getStartupFailureMessage(Exception e) {
        return "Starting the simulator failed. Please check if your model is free of error markers and every component has a defined behavior. Please consult the error log for detailed error information.";
    }

    public final List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof INamedElement && this.acceptSelection((INamedElement)selection, contextProvider)) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new SimulationEasyStartAction((INamedElement)selection)));
            return contributionItems;
        }
        return Collections.emptyList();
    }

    public class SimulationEasyStartAction
    extends EasyStartMenuBase.EasyStartAction {
        public SimulationEasyStartAction(INamedElement target) {
            super((EasyStartMenuBase)SimulatorEasyStartMenu.this, target);
        }

        public void run() {
            if (this.target instanceof ComponentArchitecture) {
                this.target = ((ComponentArchitecture)this.target).getTopComponent();
            }
            super.run();
            try {
                if (!SimulatorEasyStartMenu.this.hasError()) {
                    WorkbenchUtils.getActiveWorkbenchPage().showView(GraphicalStructureSimulationFXView.ID, Integer.toString(this.target.getId()), 1);
                }
            }
            catch (WorkbenchException e) {
                LoggingUtils.error((Plugin)AF3ComponentUIActivator.getDefault(), (String)"Could not show simulation perspective!", (Throwable)e);
            }
        }
    }
}

