/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.simulator;

import org.conqat.ide.commons.ui.dialog.MessageUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.fortiss.af3.component.simulator.ExecutableComponent;
import org.fortiss.af3.component.ui.simulator.SimulationPerspective;
import org.fortiss.af3.project.extension.base.ExecutionTargetBase;
import org.fortiss.af3.project.extension.data.Executable;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;

public abstract class SimulatorExecutionTargetBase
extends ExecutionTargetBase {
    protected void doExecute(Executable executable) {
        try {
            PlatformUI.getWorkbench().showPerspective(SimulationPerspective.ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            this.errorOnOpenPersp(e);
            MessageUtils.showError((String)"Error", (String)"Could not change to the simulation perspective. Please consult error log for details.");
        }
        ExecutableComponent execObject = (ExecutableComponent)executable.getExecutableObject();
        this.setCurrentSimulation((ExecutableComponent<IModelElementSpecification>)execObject);
    }

    public abstract String getName();

    public Class<?> getExecutableClass() {
        return ExecutableComponent.class;
    }

    protected abstract void setCurrentSimulation(ExecutableComponent<IModelElementSpecification> var1);

    protected abstract void errorOnOpenPersp(WorkbenchException var1);
}

