/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.simulator.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.simulator.ExecutableComponent;
import org.fortiss.af3.component.ui.simulator.menu.ISimulationContextMenuContributor;
import org.fortiss.af3.component.ui.simulator.menu.ISimulationContextMenuService;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.base.EObjectAwareServiceBase;

public class SimulationContextMenuService
extends EObjectAwareServiceBase<ISimulationContextMenuContributor>
implements ISimulationContextMenuService {
    private static final String EXTENSION_POINT_NAME = "org.fortiss.af3.component.ui.simulationContextMenuContribution";
    private static final String CONFIGURATION_ELEMENT_NAME = "simulationContextMenuContribution";
    private static final String HANDLER_CLASS_ATTRIBUTE_NAME = "contributor";

    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService((IIntrospectiveKernelService)this);
    }

    public String getIntrospectionDescription() {
        return "This service provides an extension point for registering simulation views.";
    }

    public String getIntrospectionLabel() {
        return "Simulation Context Menu Service";
    }

    @Override
    public ContextMenu createContextMenu(ExecutableComponent<?> execComp) {
        ContextMenu contextMenu = new ContextMenu();
        this.addContributions(contextMenu, execComp);
        return contextMenu;
    }

    @Override
    public ISimulationContextMenuContributor getTopMostContributor(ExecutableComponent<?> simulationObject) {
        Class<?> componentClass = simulationObject.getModelElement().getClass();
        ISimulationContextMenuContributor contrib = this.findTopMostContributor(simulationObject, componentClass, null);
        IModelElementSpecification specElement = simulationObject.getSpecification();
        if (specElement != null) {
            contrib = this.findTopMostContributor(simulationObject, specElement.getClass(), contrib);
        }
        return contrib;
    }

    private ISimulationContextMenuContributor findTopMostContributor(ExecutableComponent<?> simulationObject, Class<? extends EObject> elementClass, ISimulationContextMenuContributor last) {
        List contributors = this.getRegisteredHandlers(elementClass);
        if (contributors == null) {
            return last;
        }
        for (ISimulationContextMenuContributor contributor : contributors) {
            if (contributor.getContributedItem(simulationObject) == null) continue;
            if (last == null) {
                last = contributor;
                continue;
            }
            if (contributor.getMenuSectionID() >= last.getMenuSectionID()) continue;
            last = contributor;
        }
        return last;
    }

    private void addContributions(ContextMenu contextMenu, ExecutableComponent<?> execComp) {
        ExecutableComponent<?> simulationObject = execComp;
        Class<?> componentClass = simulationObject.getModelElement().getClass();
        IModelElementSpecification specElement = simulationObject.getSpecification();
        if (specElement != null) {
            this.addContributions(contextMenu, simulationObject, specElement.getClass());
        } else {
            this.addContributions(contextMenu, simulationObject, componentClass);
        }
    }

    private void addContributions(ContextMenu menu, ExecutableComponent<?> simulationObject, Class<? extends EObject> elementClass) {
        List contributors = this.getRegisteredHandlers(elementClass);
        if (contributors == null) {
            return;
        }
        HashMap displayOrder = new HashMap();
        for (ISimulationContextMenuContributor contributor : contributors) {
            List<MenuItem> list;
            int menuSectionID = contributor.getMenuSectionID();
            if (menuSectionID < 0) {
                menuSectionID = 2;
            }
            MenuItem item = contributor.getContributedItem(simulationObject);
            if (!displayOrder.containsKey(menuSectionID)) {
                list = new ArrayList<MenuItem>();
                ((ArrayList)list).add(item);
                displayOrder.put(menuSectionID, list);
                continue;
            }
            list = (List)displayOrder.get(menuSectionID);
            list.add(item);
        }
        int lastID = -1;
        for (Map.Entry e : displayOrder.entrySet()) {
            if ((Integer)e.getKey() == 4 && lastID != 4) {
                menu.getItems().add((Object)new SeparatorMenuItem());
            }
            for (MenuItem item : (List)e.getValue()) {
                if (item == null) continue;
                menu.getItems().add((Object)item);
            }
            lastID = (Integer)e.getKey();
        }
    }

    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    protected String getConfigurationElementName() {
        return CONFIGURATION_ELEMENT_NAME;
    }

    protected String getHandlerClassAttribute() {
        return HANDLER_CLASS_ATTRIBUTE_NAME;
    }
}

