/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.simulatorfx.views;

import javafx.scene.Parent;
import javafx.scene.Scene;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.ui.simulatorfx.views.SimulationFXViewBase;

public abstract class CustomSimulationFXViewBase<T extends EObject>
extends SimulationFXViewBase {
    private T lastElement = null;
    private final Class<T> type;

    protected CustomSimulationFXViewBase(Class<T> type) {
        this.type = type;
    }

    protected Scene createFxScene() {
        String name = "ERROR";
        if (this.getModelElement() != null) {
            name = this.getModelElement().getName();
        }
        this.setPartName(name + " Simulation");
        Scene scene = new Scene(this.createFXPartScene());
        this.updateVisualsAsync();
        return scene;
    }

    protected abstract void updateVisuals(T var1);

    @Override
    protected final void refreshViewer() {
        Component modelElement = this.getModelElement();
        if (!this.type.isInstance(modelElement)) {
            return;
        }
        if (modelElement != this.lastElement) {
            this.lastElement = modelElement;
            this.setModelElement(this.lastElement);
        }
        if (modelElement.getComment() != null) {
            this.setContentDescription(modelElement.getComment());
        }
        this.updateVisuals(this.lastElement);
    }

    protected abstract Parent createFXPartScene();

    protected abstract void setModelElement(T var1);
}

