/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.simulatorfx.views;

import java.util.Collection;
import java.util.Collections;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.simulator.ExecutableAtomicComponentBase;
import org.fortiss.af3.component.ui.simulatorfx.views.SimulationFXViewBase;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.typesystem.ITypeChecker;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;

public final class DataStateTableViewFX
extends SimulationFXViewBase {
    private DynamicTreeTableViewer<Object> treeTableViewer;
    private TextField filterWidget;
    public static final String ID = DataStateTableViewFX.class.getName();
    private final String variableColName = "Variable";
    private final int variableColNr = 0;
    private final String currentColName = "Current";
    private final int currentColNr = 1;
    private final String nextColName = "Next";
    private final int nextColNr = 2;

    protected final Scene createFxScene() {
        BorderPane pane = new BorderPane();
        ContentProvider contentProvider = new ContentProvider();
        UIProvider uiProvider = new UIProvider();
        this.filterWidget = new TextField();
        this.filterWidget.textProperty().addListener((obs, oVal, nVal) -> {
            contentProvider.setFilterExpression((String)nVal);
            this.treeTableViewer.update();
        });
        ExecutableAtomicComponentBase spec = (ExecutableAtomicComponentBase)this.executable;
        this.treeTableViewer = new DynamicTreeTableViewer((Object)spec, false, 2, (DynamicTreeContentProviderBase)contentProvider, (DynamicTreeTableUIProviderBase)uiProvider);
        pane.setTop((Node)this.filterWidget);
        pane.setCenter((Node)this.treeTableViewer.getControl());
        this.filterWidget = new TextField();
        this.filterWidget.textProperty().addListener((obs, oVal, nVal) -> {
            contentProvider.setFilterExpression((String)nVal);
            this.treeTableViewer.update();
            this.treeTableViewer.expandAllItems();
        });
        this.filterWidget.setTooltip(new Tooltip("type filter text"));
        this.filterWidget.setPromptText("type filter text");
        this.treeTableViewer.addColumn("Variable", 160);
        this.treeTableViewer.addColumn("Current", 160);
        this.treeTableViewer.addColumn("Next", 160);
        if (this.executable != null) {
            this.setPartName(this.executable.getModelElement().getName() + " Data State");
        }
        this.updateVisualsAsync();
        return new Scene((Parent)pane);
    }

    protected void setFxFocus() {
        this.treeTableViewer.getControl().requestFocus();
    }

    @Override
    protected void refreshViewer() {
        this.treeTableViewer.update();
    }

    private class ContentProvider
    extends DynamicTreeContentProviderBase<Object> {
        private ContentProvider() {
        }

        protected Collection<? extends Object> getChildren(Object parent) {
            if (parent instanceof ExecutableAtomicComponentBase) {
                ExecutableAtomicComponentBase spec = (ExecutableAtomicComponentBase)parent;
                return spec.dataStateVariables.values();
            }
            return Collections.emptyList();
        }

        protected boolean filter(Object element, String filterValue) {
            return true;
        }
    }

    private class UIProvider
    extends DynamicTreeTableUIProviderBase<Object> {
        private UIProvider() {
        }

        public String getLabel(Object element, int column) {
            if (!(element instanceof DataStateVariable)) {
                return "Unknown type " + element.getClass().getSimpleName();
            }
            DataStateVariable dsv = (DataStateVariable)element;
            if (column == 0) {
                return dsv.getIdentifier();
            }
            if (column == 1) {
                return this.obtainCurrentSimulationValue(dsv);
            }
            if (column == 2) {
                return this.obtainNextSimulationValue(dsv);
            }
            return "Missing label provider for column " + column;
        }

        public Node getIconNode(Object element, int column) {
            return null;
        }

        protected String obtainCurrentSimulationValue(DataStateVariable element) {
            Term t = ((ExecutableAtomicComponentBase)DataStateTableViewFX.this.executable).getCurrentVariableValue(element);
            if (t != null) {
                return t.toString();
            }
            return "---";
        }

        protected String obtainNextSimulationValue(DataStateVariable element) {
            Term t = ((ExecutableAtomicComponentBase)DataStateTableViewFX.this.executable).getNextVariableValue(element);
            if (t != null) {
                return t.toString();
            }
            return "---";
        }

        public boolean isEditable(int column) {
            return column == 2;
        }

        public void updateValue(Object element, int column, Object value) {
            if (column == 2 && element instanceof DataStateVariable) {
                DataStateVariable dsv = (DataStateVariable)element;
                String valueAsString = value.toString();
                if (valueAsString.trim().length() == 0) {
                    DataStateTableViewFX.this.executable.setInternalValue((EObject)dsv, (Object)NoVal.NOVAL);
                } else {
                    ITerm compileToITerm = DataStateTableViewFX.this.executable.compileToITerm(valueAsString);
                    ITypeChecker.IFastChecker fastChecker = DataStateTableViewFX.this.executable.getTypeChecker().createFastChecker(dsv.getVariableType(), (EObject)dsv);
                    ITerm t = DataStateTableViewFX.this.executable.compileToITerm(value.toString());
                    IStatus typecheckRes = fastChecker.typecheck(t);
                    if (t == null || !typecheckRes.isOK()) {
                        MessageUtilsExtended.showErrorInUIThread((String)"Compile error", (String)("Cannot compile value \"" + valueAsString + "\"\nSetting value to \"NoVal\""));
                        DataStateTableViewFX.this.executable.setInternalValue((EObject)dsv, (Object)NoVal.NOVAL);
                        return;
                    }
                    DataStateTableViewFX.this.executable.setInternalValue((EObject)dsv, (Object)DataStateTableViewFX.this.executable.getTermValue(compileToITerm));
                    DataStateTableViewFX.this.postRefreshEventToViews();
                }
            }
        }
    }
}

