/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.simulatorfx.views;

import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPartSite;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.simulator.ExecutableComponent;
import org.fortiss.af3.component.ui.editor.structure.ComponentModelFactory;
import org.fortiss.af3.component.ui.editor.structure.ComponentVisualFactory;
import org.fortiss.af3.component.ui.editor.structure.controller.PortContentAnchorageController;
import org.fortiss.af3.component.ui.editor.structure.visual.ChannelVisual;
import org.fortiss.af3.component.ui.simulatorfx.views.CustomSimulationFXViewBase;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.tooling.base.ui.editor.fx.controller.EObjectDiagramController;
import org.fortiss.tooling.base.ui.editor.fx.controller.LayoutedDiagramAnchorageController;
import org.fortiss.tooling.base.ui.editor.fx.controller.LayoutedLineLinkBendPointController;
import org.fortiss.tooling.base.ui.editor.fx.controller.LayoutedRectangularResizableContentController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewer;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IClickController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IControllerFactory;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IDragController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.ClickControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IDiagramAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IDiagramMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.ILinkVisual;

public abstract class GraphicalSimulationFXView<T extends EObject>
extends CustomSimulationFXViewBase<T> {
    private final ActionRegistry actionRegistry = new ActionRegistry();
    protected DiagramViewer viewer;

    protected GraphicalSimulationFXView(Class<T> type) {
        super(type);
    }

    @Override
    public Parent createFXPartScene() {
        ComponentModelFactory delegatingModelFactory = new ComponentModelFactory(this.getModelElement());
        SimulationComponentVisualFactory delegatingVisualFactory = new SimulationComponentVisualFactory();
        SimulationComponentControllerFactory delegatingControllerFactory = new SimulationComponentControllerFactory();
        this.viewer = new DiagramViewer(delegatingModelFactory, delegatingVisualFactory, delegatingControllerFactory, cb -> this.modelSelected(), chg -> this.applyModelChange()){

            public IDragController createDragController(IMVCBundle bundle, EDragGesture gesture, Node source, DiagramCoordinate lastMouseLocation) {
                return null;
            }
        };
        return this.viewer.getVisualNode();
    }

    protected void modelSelected() {
        IWorkbenchPartSite site = this.getSite();
        ISelectionProvider selectionProvider = site.getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.setSelection((ISelection)this.createSelection());
        }
    }

    protected void applyModelChange() {
    }

    private IStructuredSelection createSelection() {
        return StructuredSelection.EMPTY;
    }

    protected final String registerAction(IAction action) {
        this.actionRegistry.registerAction(action);
        return action.getId();
    }

    public void setFocus() {
        this.viewer.getVisualNode().requestFocus();
    }

    public final class SimulationComponentControllerFactory
    implements IControllerFactory {
        public IController createContentController(IContentMVCBundle model) {
            return new LayoutedRectangularResizableContentController<Component>(model, Component.class){

                public IClickController getClickController(Node node, DiagramCoordinate diagramLocation) {
                    return new ClickControllerBase(){

                        public Change doubleClick(MouseEvent event, Node node, DiagramCoordinate diagramLocation) {
                            return null;
                        }
                    };
                }
            };
        }

        public IController createDiagramAnchorageController(IDiagramAnchorageMVCBundle modelBundle) {
            return new LayoutedDiagramAnchorageController<Port>((IMVCBundle)modelBundle, Port.class){

                protected boolean selectOnClick() {
                    return false;
                }
            };
        }

        public IController createContentAnchorageController(IContentAnchorageMVCBundle modelBundle) {
            return new PortContentAnchorageController(modelBundle){

                protected boolean selectOnClick() {
                    return false;
                }
            };
        }

        public IController createLinkController(ILinkMVCBundle modelBundle) {
            return new LayoutedLineLinkBendPointController<Channel>(modelBundle, Channel.class){

                public IDragController getDragController(EDragGesture gesture, Node node, DiagramCoordinate diagramLocation) {
                    return null;
                }
            };
        }

        public IController createDiagramController(IDiagramMVCBundle diagramBundle) {
            return new EObjectDiagramController<Component>((IMVCBundle)diagramBundle, Component.class){

                protected boolean selectOnClick() {
                    return false;
                }
            };
        }
    }

    public final class SimulationComponentVisualFactory
    extends ComponentVisualFactory {
        @Override
        public ILinkVisual createLinkVisual(final ILinkMVCBundle modelBundle) {
            Object linkObj = modelBundle.getModel();
            if (linkObj instanceof Channel) {
                return new ChannelVisual(modelBundle){

                    protected String getSimulationLabelText(int currentSegment, int lastSegment) {
                        Object model = modelBundle.getModel();
                        if (model instanceof Channel) {
                            Channel channel = (Channel)model;
                            Port sourcePort = channel.getSource();
                            ExecutableComponent currentExecutable = ((SimulationComponentVisualFactory)SimulationComponentVisualFactory.this).GraphicalSimulationFXView.this.executable.findExecutable((EObject)sourcePort.getComponent());
                            if (currentExecutable == null) {
                                return "-";
                            }
                            Term t = currentExecutable.getCurrentValue(sourcePort);
                            String simulationValue = t == null ? "" : t.toString();
                            return simulationValue;
                        }
                        return super.getSimulationLabelText(currentSegment, lastSegment);
                    }
                };
            }
            return null;
        }
    }
}

