/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.simulatorfx.views;

import java.util.Collection;
import java.util.Collections;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SplitPane;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.simulator.ExecutableComponent;
import org.fortiss.af3.component.ui.simulatorfx.views.SimulationFXViewBase;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.typesystem.ITypeChecker;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;

public final class InputOutputTableFXView
extends SimulationFXViewBase {
    public static final String ID = InputOutputTableFXView.class.getName();
    private DynamicTreeTableViewer<Object> treeTableViewerInput;
    private DynamicTreeTableViewer<Object> treeTableViewerOutput;

    protected final Scene createFxScene() {
        SplitPane pane = new SplitPane();
        PortContentProvider contentProvider = new PortContentProvider(InputPort.class);
        PortContentProvider contentProvider2 = new PortContentProvider(OutputPort.class);
        UIProvider uiProvider = new UIProvider(true);
        UIProvider uiProvider2 = new UIProvider(false);
        this.treeTableViewerInput = new DynamicTreeTableViewer((Object)this.executable, false, 2, (DynamicTreeContentProviderBase)contentProvider, (DynamicTreeTableUIProviderBase)uiProvider);
        this.treeTableViewerOutput = new DynamicTreeTableViewer((Object)this.executable, false, 2, (DynamicTreeContentProviderBase)contentProvider2, (DynamicTreeTableUIProviderBase)uiProvider2);
        pane.getItems().add((Object)this.treeTableViewerInput.getControl());
        pane.getItems().add((Object)this.treeTableViewerOutput.getControl());
        this.treeTableViewerInput.addColumn("Input Port", 160);
        this.treeTableViewerInput.addColumn("Current", 160);
        this.treeTableViewerInput.addColumn("Next", 160);
        this.treeTableViewerInput.addCheckboxColumn("Hold", 160);
        this.treeTableViewerOutput.addColumn("Output Port", 160);
        this.treeTableViewerOutput.addColumn("Current", 160);
        this.treeTableViewerOutput.addColumn("Next", 160);
        if (this.executable != null) {
            this.setPartName(this.executable.getModelElement().getName() + " In-/Output");
        }
        this.updateVisualsAsync();
        return new Scene((Parent)pane);
    }

    @Override
    protected void simulationInputChanged() {
        this.refreshViewer();
    }

    @Override
    protected void refreshViewer() {
        this.treeTableViewerOutput.update();
        this.treeTableViewerInput.update();
    }

    public void setFocus() {
        this.treeTableViewerOutput.getControl().requestFocus();
    }

    protected void setFxFocus() {
        this.treeTableViewerInput.getControl().requestFocus();
    }

    private class PortContentProvider
    extends DynamicTreeContentProviderBase<Object> {
        Class<? extends Port> portClass = null;

        public PortContentProvider(Class<? extends Port> clazz) {
            this.portClass = clazz;
        }

        protected Collection<? extends Object> getChildren(Object parent) {
            if (parent instanceof ExecutableComponent) {
                EList connectors = ((ExecutableComponent)parent).getModelElement().getConnectors();
                return LambdaUtils.filterList((Collection)connectors, p -> this.portClass.isAssignableFrom(p.getClass()));
            }
            return Collections.emptyList();
        }
    }

    private class UIProvider
    extends DynamicTreeTableUIProviderBase<Object> {
        private boolean isInputPort;

        public UIProvider(boolean isInputPort) {
            this.isInputPort = isInputPort;
        }

        public String getLabel(Object element, int column) {
            if (!(element instanceof Port)) {
                return "Unknown element " + element.getClass().getSimpleName();
            }
            Port port = (Port)element;
            if (column == 0) {
                return port.getName();
            }
            if (column == 1) {
                return this.obtainCurrentSimulationValue(port);
            }
            if (column == 2) {
                return this.obtainNextSimulationValue(port);
            }
            if (column == 3) {
                return "" + InputOutputTableFXView.this.executable.isSignalOnHold(port);
            }
            return "Unknown column " + column;
        }

        protected String obtainCurrentSimulationValue(Port element) {
            Term t = null;
            t = element instanceof InputPort ? InputOutputTableFXView.this.executable.getCurrentInputValue((InputPort)element) : InputOutputTableFXView.this.executable.getCurrentOutputValue((OutputPort)element);
            if (t != null) {
                return t.toString();
            }
            return "n/a";
        }

        protected String obtainNextSimulationValue(Port element) {
            Term t = null;
            t = element instanceof InputPort ? InputOutputTableFXView.this.executable.getNextInputValue((InputPort)element) : InputOutputTableFXView.this.executable.getNextOutputValue((OutputPort)element);
            if (t != null) {
                return t.toString();
            }
            return "n/a";
        }

        public boolean isEditable(int column) {
            return column == 2 && this.isInputPort || column == 3;
        }

        public void updateValue(Object element, int column, Object value) {
            if (column == 3 && element instanceof InputPort) {
                InputOutputTableFXView.this.executable.setHoldSignal((Port)((InputPort)element), ((Boolean)value).booleanValue());
                InputOutputTableFXView.this.postRefreshEventToViews();
            }
            if (column == 2 && element instanceof InputPort) {
                String valueAsString = value.toString();
                ITerm compileToITerm = InputOutputTableFXView.this.executable.compileToITerm(valueAsString);
                InputPort inputPort = (InputPort)element;
                IType variableType = inputPort.getVariableType();
                if (compileToITerm == null) {
                    this.showCompileError(valueAsString, variableType);
                    return;
                }
                ITypeChecker typeChecker = InputOutputTableFXView.this.executable.getTypeChecker();
                IStatus typecheck = typeChecker.typecheck(compileToITerm, variableType, (EObject)variableType);
                if (typecheck == null || !typecheck.isOK()) {
                    this.showCompileError(valueAsString, variableType);
                    return;
                }
                InputOutputTableFXView.this.executable.setNextInputValue(inputPort, compileToITerm);
                InputOutputTableFXView.this.postRefreshEventToViews();
            }
        }

        private void showCompileError(String valueAsString, IType variableType) {
            String message = "Cannot compile value \"" + valueAsString + "\". Expected type " + variableType.getTypeClassName() + "\nRe-Setting value";
            message = message + "\nQuick help: \nArrays\t-> [1,2,3,4]\nStructs\t-> {x:1,y:2}\ndouble\t-> 1.0\nboolean\t-> true\ninteger\t-> 1";
            MessageUtilsExtended.showErrorInUIThread((String)"Compile error", (String)message);
        }
    }
}

