/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.simulatorfx.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IPropertyListener;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.simulator.ExecutableComponent;
import org.fortiss.af3.component.ui.simulator.SimulationManager;
import org.fortiss.af3.component.ui.simulator.menu.ISimulationContextMenuContributor;
import org.fortiss.af3.component.ui.simulator.menu.ISimulationContextMenuService;
import org.fortiss.af3.component.ui.utils.SimulationUtils;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.IDoubleClickHandler;
import org.fortiss.tooling.common.ui.javafx.layout.CompositeFXControllerBase;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;
import org.fortiss.tooling.common.ui.javafx.util.JavaFXUtils;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;

public class SimulationNavigatorController
extends CompositeFXControllerBase<TreeView<INamedElement>, Node>
implements IPropertyListener {
    @FXML
    private Button playBtn;
    @FXML
    private Button pauseBtn;
    @FXML
    private Button backBtn;
    @FXML
    private Button forwBtn;
    @FXML
    private Button resetBtn;
    @FXML
    private ComboBox<Integer> speedCombo;
    @FXML
    private TextField currentStep;
    @FXML
    private BorderPane borderPane;
    private final Integer[] initialStepLengths = new Integer[]{1000, 500, 250, 200, 150, 100, 50, 25, 10};
    DynamicTreeTableViewer<Object> treeTable;
    private StepCounter counter;

    public SimulationNavigatorController() {
        super(new ICompositeFXController[0]);
    }

    public String getFXMLLocation() {
        return "SimulationNavigator.fxml";
    }

    public void initialize() {
        SimulationUtils.closeUnrelatedViews();
        String iconPath = "/icons/simulator/";
        ImageView runGraphic = new ImageView(iconPath + "run.png");
        this.playBtn.setGraphic((Node)runGraphic);
        this.playBtn.setText("");
        this.playBtn.setTooltip(JavaFXUtils.createToolTip((String)"Run Simulation"));
        ImageView pauseGraphic = new ImageView(iconPath + "pause.png");
        this.pauseBtn.setGraphic((Node)pauseGraphic);
        this.pauseBtn.setText("");
        this.pauseBtn.setTooltip(JavaFXUtils.createToolTip((String)"Pause Simulation"));
        ImageView backGraphic = new ImageView(iconPath + "back.png");
        this.backBtn.setGraphic((Node)backGraphic);
        this.backBtn.setText("");
        this.backBtn.setTooltip(JavaFXUtils.createToolTip((String)"Reverse last simulation step"));
        ImageView forwGraphic = new ImageView(iconPath + "step.png");
        this.forwBtn.setGraphic((Node)forwGraphic);
        this.forwBtn.setText("");
        this.forwBtn.setTooltip(JavaFXUtils.createToolTip((String)"Execute one simulation step"));
        ImageView resetGraphic = new ImageView(iconPath + "reset.png");
        this.resetBtn.setGraphic((Node)resetGraphic);
        this.resetBtn.setText("");
        this.resetBtn.setTooltip(JavaFXUtils.createToolTip((String)"Reset simulation"));
        this.speedCombo.setTooltip(JavaFXUtils.createToolTip((String)"Set simulation speed of one step in [ms]"));
        this.speedCombo.getItems().addAll(Arrays.asList(this.initialStepLengths));
        SimulationNavigatorContentProvider contentProvider = new SimulationNavigatorContentProvider();
        SimulationNavigatorUIProvider uiProvider = new SimulationNavigatorUIProvider();
        this.treeTable = new DynamicTreeTableViewer((Object)SimulationManager.INSTANCE, false, 2, (DynamicTreeContentProviderBase)contentProvider, (DynamicTreeTableUIProviderBase)uiProvider);
        this.treeTable.addColumn("Name", 200);
        this.treeTable.setDoubleClickHandler((IDoubleClickHandler)new DoubleClickHandler());
        this.borderPane.setCenter((Node)this.treeTable.getControl());
        this.updateActions();
        SimulationManager.INSTANCE.addListener(this);
        this.counter = new StepCounter(this.currentStep);
        this.treeTable.update();
        this.treeTable.expandToLevel(3);
    }

    public void onPlayBtn() {
        SimulationManager.INSTANCE.run();
    }

    public void onPauseBtn() {
        SimulationManager.INSTANCE.pause();
    }

    public void onBackBtn() {
        SimulationManager.INSTANCE.performStepBack();
        SimulationManager.INSTANCE.showLastErrorMessage();
    }

    public void onForwBtn() {
        SimulationManager.INSTANCE.performStep();
        SimulationManager.INSTANCE.showLastErrorMessage();
    }

    public void onResetBtn() {
        SimulationManager.INSTANCE.reset();
    }

    public void onSpeedCombo() {
        SingleSelectionModel speed = this.speedCombo.getSelectionModel();
        SimulationManager.INSTANCE.setSpeed((Integer)speed.getSelectedItem());
    }

    private void updateActions() {
        if (SimulationManager.INSTANCE.getCurrentSimulation() != null) {
            boolean isRunning = SimulationManager.INSTANCE.isSimulationRunning();
            if (isRunning) {
                this.pauseBtn.setDisable(false);
                this.forwBtn.setDisable(true);
                this.backBtn.setDisable(true);
                this.playBtn.setDisable(true);
            } else {
                this.pauseBtn.setDisable(true);
                this.forwBtn.setDisable(false);
                boolean enableBack = this.counter != null ? this.counter.stepCount > 0 : false;
                this.backBtn.setDisable(!enableBack);
                this.playBtn.setDisable(false);
            }
            this.resetBtn.setDisable(false);
        } else {
            this.pauseBtn.setDisable(true);
            this.forwBtn.setDisable(true);
            this.backBtn.setDisable(true);
            this.playBtn.setDisable(true);
            this.resetBtn.setDisable(true);
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (source == SimulationManager.INSTANCE) {
            if (propId == 1) {
                this.treeTable.update();
                this.treeTable.expandToLevel(3);
                SimulationUtils.closeUnrelatedViews();
            } else if (propId == 2) {
                this.counter.incCounter();
            } else if (propId == 4) {
                this.counter.resetCounter();
            } else if (propId == 5) {
                this.counter.decCounter();
            }
            this.updateActions();
        }
    }

    private class DoubleClickHandler
    implements IDoubleClickHandler {
        private DoubleClickHandler() {
        }

        public void doubleClicked(Object value) {
            if (value instanceof ExecutableComponent) {
                ISimulationContextMenuContributor topMostContributor = ISimulationContextMenuService.INSTANCE.getTopMostContributor((ExecutableComponent)value);
                SimulationUtils.showSimulationView(topMostContributor.getViewID(), ((ExecutableComponent)value).getModelElement());
            }
        }
    }

    private class SimulationNavigatorContentProvider
    extends DynamicTreeContentProviderBase<Object> {
        private SimulationNavigatorContentProvider() {
        }

        protected Collection<? extends Object> getChildren(Object parent) {
            if (parent instanceof SimulationManager) {
                SimulationManager man = (SimulationManager)parent;
                if (man.getCurrentSimulation() != null) {
                    ArrayList<ExecutableComponent<? extends IModelElementSpecification>> list = new ArrayList<ExecutableComponent<? extends IModelElementSpecification>>();
                    list.add(man.getCurrentSimulation());
                    return list;
                }
            } else if (parent instanceof ExecutableComponent) {
                return ((ExecutableComponent)parent).getSubElements();
            }
            return null;
        }
    }

    private class SimulationNavigatorUIProvider
    extends DynamicTreeTableUIProviderBase<Object> {
        private SimulationNavigatorUIProvider() {
        }

        public String getLabel(Object element, int column) {
            if (element instanceof ExecutableComponent) {
                return ((ExecutableComponent)element).getModelElement().getName();
            }
            return super.getLabel(element, column);
        }

        public Node getIconNode(Object element, int column) {
            if (element instanceof ExecutableComponent) {
                Component modelElement = ((ExecutableComponent)element).getModelElement();
                IModelElementSpecification spec = ((ExecutableComponent)element).getSpecification();
                if (spec != null) {
                    return IModelElementHandlerService.getInstance().getFXIcon((EObject)spec);
                }
                return IModelElementHandlerService.getInstance().getFXIcon((EObject)modelElement);
            }
            return super.getIconNode(element, column);
        }

        public ContextMenu createContextMenu(Object element, int column) {
            if (element == null || column != 0 || !(element instanceof ExecutableComponent)) {
                return null;
            }
            ContextMenu contextMenu = ISimulationContextMenuService.INSTANCE.createContextMenu((ExecutableComponent)element);
            return contextMenu;
        }
    }

    class StepCounter
    implements EventListener {
        private int stepCount = 0;
        private TextField stepCounterText;

        public StepCounter(TextField currentStep) {
            this.stepCounterText = currentStep;
        }

        public void setStepCounter(int newSC) {
            this.stepCount = newSC;
            this.stepCounterText.setText(String.valueOf(this.stepCount));
        }

        public void incCounter() {
            ++this.stepCount;
            this.stepCounterText.setText(String.valueOf(this.stepCount));
        }

        public void decCounter() {
            if (this.stepCount != 0) {
                --this.stepCount;
                this.stepCounterText.setText(String.valueOf(this.stepCount));
            } else {
                this.stepCounterText.setText(String.valueOf(this.stepCount));
            }
        }

        public void resetCounter() {
            this.stepCount = 0;
            this.stepCounterText.setText(String.valueOf(this.stepCount));
        }
    }
}

