/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.utils;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.ui.AF3ComponentUIActivator;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.af3.expression.ui.utils.ExpressionFieldAssistUtils;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.ui.fieldassist.FieldAssistImageRegistry;
import org.fortiss.tooling.kernel.model.INamedElement;

public class ComponentFieldAssistUtils {
    static Image INPUT_PORT_ICON = AF3ComponentUIActivator.getImageDescriptor("/icons/entry_ipoint.png").createImage();
    static Image OUTPUT_PORT_ICON = AF3ComponentUIActivator.getImageDescriptor("/icons/exit_ipoint.png").createImage();

    public static ArrayList<String> getInputPortNames(Component component) {
        ArrayList<String> result = new ArrayList<String>();
        for (IConnector conn : component.getConnectors()) {
            if (!(conn instanceof INamedElement) || !(conn instanceof InputPort)) continue;
            result.add(((INamedElement)conn).getName());
            FieldAssistImageRegistry.put((String)((INamedElement)conn).getName(), (Image)INPUT_PORT_ICON);
        }
        return result;
    }

    public static ArrayList<String> getOutputPortNames(Component component) {
        ArrayList<String> result = new ArrayList<String>();
        for (IConnector conn : component.getConnectors()) {
            if (!(conn instanceof INamedElement) || !(conn instanceof OutputPort)) continue;
            result.add(((INamedElement)conn).getName());
            FieldAssistImageRegistry.put((String)((INamedElement)conn).getName(), (Image)OUTPUT_PORT_ICON);
        }
        return result;
    }

    public static String[] createComponentInOutProposals(EObject obj) {
        ArrayList<String> prop = ComponentFieldAssistUtils.getOutputPortNames(ComponentArchitectureUtils.getEnclosingComponent((EObject)obj));
        prop.addAll(Arrays.asList(ComponentFieldAssistUtils.createComponentInProposals(obj)));
        return prop.toArray(new String[0]);
    }

    public static String[] createComponentInProposals(EObject obj) {
        ArrayList<String> prop = ComponentFieldAssistUtils.getInputPortNames(ComponentArchitectureUtils.getEnclosingComponent((EObject)obj));
        prop.addAll(ExpressionFieldAssistUtils.getFunctions((EObject)obj));
        prop.addAll(ExpressionFieldAssistUtils.getAllConstructors((EObject)obj, (boolean)true));
        prop.addAll(ExpressionFieldAssistUtils.getPrimitiveValues());
        return prop.toArray(new String[0]);
    }

    public static String[] createComponentOutProposals(EObject obj) {
        ArrayList<String> prop = ComponentFieldAssistUtils.getOutputPortNames(ComponentArchitectureUtils.getEnclosingComponent((EObject)obj));
        prop.addAll(ExpressionFieldAssistUtils.getFunctions((EObject)obj));
        prop.addAll(ExpressionFieldAssistUtils.getAllConstructors((EObject)obj, (boolean)true));
        prop.addAll(ExpressionFieldAssistUtils.getPrimitiveValues());
        return prop.toArray(new String[0]);
    }
}

