/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.utils;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.terms.DoubleConst;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.Return;

public class FMUUtils {
    public static final String SAMPLING_TIME_NAME = "SAMPLING_TIME";

    public static Double getSamplingTime(DataDictionary dd, double lastSelectedFrequency) {
        Shell currentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Object message = "";
        String baseMsg = "- The 'SAMPLING_TIME' function must ";
        Double samplingTime = null;
        if (dd != null) {
            for (FunctionDefinition function : dd.getFunctions()) {
                Return returnStatement;
                EList statements;
                if (!function.getFunction().getName().toString().equals(SAMPLING_TIME_NAME)) continue;
                if (!function.getReturnType().toString().contains("double")) {
                    message = (String)message + baseMsg + "return a value of type 'double'." + System.lineSeparator();
                }
                if ((statements = function.getDefinition().getStatements()).size() != 1) {
                    message = (String)message + baseMsg + "contain one and only one statement." + System.lineSeparator();
                    continue;
                }
                IStatementTerm singleStatement = (IStatementTerm)statements.get(0);
                if (!(singleStatement instanceof Return)) {
                    message = (String)message + baseMsg + "contain a 'return' statement." + System.lineSeparator();
                }
                if (!((returnStatement = (Return)singleStatement).getValue() instanceof DoubleConst)) {
                    message = (String)message + baseMsg + "return a constant value [seconds per tick] (e.g. '0.01')." + System.lineSeparator();
                    continue;
                }
                samplingTime = ((DoubleConst)returnStatement.getValue()).getValue();
            }
            if (samplingTime == null) {
                message = (String)message + baseMsg + "be defined in the data dictionary." + System.lineSeparator();
            }
        } else {
            message = (String)message + baseMsg + "be defined in a data dictionary, but no data dictionary exist yet." + System.lineSeparator();
        }
        if (!((String)message).equals("")) {
            InputDialog durationDialog = new InputDialog(currentShell, "Frequency", "SAMPLING_TIME() function definition error:" + System.lineSeparator() + (String)message + System.lineSeparator() + "As sampling time function is not (properly) defined, please provide the frequency of the component in Hertz:", String.valueOf(lastSelectedFrequency), (IInputValidator)new NumberValidator());
            if (durationDialog.open() != 0) {
                return null;
            }
            lastSelectedFrequency = Double.parseDouble(durationDialog.getValue());
            samplingTime = 1.0 / lastSelectedFrequency;
        }
        double toMilliseconds = 1000.0;
        samplingTime = samplingTime != null ? Double.valueOf(samplingTime * 1000.0) : null;
        return samplingTime;
    }

    private static class NumberValidator
    implements IInputValidator {
        private NumberValidator() {
        }

        public String isValid(String input) {
            try {
                if (Double.parseDouble(input) <= 0.0) {
                    return "Please enter a positive (non-null) number.";
                }
            }
            catch (NumberFormatException x) {
                return "Please enter a number.";
            }
            return null;
        }
    }
}

