/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.utils;

import java.util.EventObject;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.simulator.ExecutableComponent;
import org.fortiss.af3.component.ui.simulator.SimulationManager;
import org.fortiss.af3.component.ui.simulator.SimulationPerspective;
import org.fortiss.af3.component.ui.simulator.SimulatorEasyStartMenu;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IPersistencyService;

public class SimulationPerspectiveListener
implements IPerspectiveListener {
    private String lastID = null;
    private static boolean STACK_LISTENER_ADDED = false;
    private boolean STACK_CHANGED = false;
    private CommandStackListener listener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            SimulationPerspectiveListener.this.STACK_CHANGED = true;
        }
    };

    public synchronized void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        ExecutableComponent<? extends IModelElementSpecification> currentSimulation = SimulationManager.INSTANCE.getCurrentSimulation();
        if (currentSimulation == null) {
            return;
        }
        Component modelElement = currentSimulation.getModelElement();
        if (!STACK_LISTENER_ADDED) {
            ITopLevelElement top = IPersistencyService.getInstance().getTopLevelElementFor((EObject)modelElement);
            ICommandStackService.getInstance().addCommandStackListener(top, this.listener);
            STACK_LISTENER_ADDED = true;
        }
        if (this.lastID != null && !this.lastID.equals(SimulationPerspective.ID) && perspective.getId().equals(SimulationPerspective.ID) && this.STACK_CHANGED) {
            SimulatorEasyStartMenu menu;
            SimulatorEasyStartMenu simulatorEasyStartMenu = menu = new SimulatorEasyStartMenu();
            ((Object)((Object)simulatorEasyStartMenu)).getClass();
            SimulatorEasyStartMenu.SimulationEasyStartAction d = new SimulatorEasyStartMenu.SimulationEasyStartAction(simulatorEasyStartMenu, (INamedElement)modelElement);
            d.run();
            this.STACK_CHANGED = false;
        }
        this.lastID = perspective.getId();
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }
}

