/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.ui.utils;

import org.conqat.ide.commons.ui.ui.WorkbenchUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.simulator.ExecutableComponent;
import org.fortiss.af3.component.ui.AF3ComponentUIActivator;
import org.fortiss.af3.component.ui.simulator.SimulationManager;
import org.fortiss.af3.component.ui.simulator.SimulationPerspective;
import org.fortiss.af3.component.ui.simulatorfx.views.SimulationFXViewBase;
import org.fortiss.af3.component.ui.utils.SimulationPerspectiveListener;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class SimulationUtils {
    private static boolean perspectiveListenerAdded = false;

    public static IWorkbenchPage showSimulationPerpective() throws WorkbenchException {
        return PlatformUI.getWorkbench().showPerspective(SimulationPerspective.ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public static void showSimulationView(String viewId, Component observedComponent) {
        String secondaryId = Integer.toString(observedComponent.getId());
        try {
            WorkbenchUtils.getActiveWorkbenchPage().showView(viewId, secondaryId, 1);
        }
        catch (PartInitException e) {
            LoggingUtils.error((Plugin)AF3ComponentUIActivator.getDefault(), (String)"Could not show simulation view!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeUnrelatedViews() {
        IWorkbenchWindow activeWorkbenchWindow;
        ExecutableComponent<? extends IModelElementSpecification> simulationObject = SimulationManager.INSTANCE.getCurrentSimulation();
        IWorkbenchPartSite viewSite = WorkbenchUtils.getActiveWorkbenchPage().getActivePart().getSite();
        IWorkbenchWindow iWorkbenchWindow = activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        synchronized (iWorkbenchWindow) {
            if (!perspectiveListenerAdded) {
                activeWorkbenchWindow.addPerspectiveListener((IPerspectiveListener)new SimulationPerspectiveListener());
                perspectiveListenerAdded = true;
            }
        }
        IViewReference[] iViewReferenceArray = viewSite.getWorkbenchWindow().getActivePage().getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference vref = iViewReferenceArray[n2];
            IViewPart vpart = vref.getView(false);
            if (vpart == null) {
                viewSite.getWorkbenchWindow().getActivePage().hideView(vref);
            } else if (vpart instanceof SimulationFXViewBase) {
                SimulationFXViewBase svb = (SimulationFXViewBase)vpart;
                if (simulationObject == null || svb.getModelElement() == null || simulationObject.findSimilarExecutable((EObject)svb.getModelElement()) == null) {
                    viewSite.getWorkbenchWindow().getActivePage().hideView(vpart);
                }
            }
            ++n2;
        }
    }
}

