/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.consistency.ui.commands;

import org.eclipse.jface.action.Action;
import org.fortiss.af3.consistency.ui.AF3ConsistencyUIActivator;
import org.fortiss.af3.consistency.ui.utils.ConsistencyUIUtils;
import org.fortiss.consistency.CentralConsistencyEnvironment;
import org.fortiss.tooling.ext.consistency.ConsistencyAdapterEnvironment;
import org.fortiss.tooling.ext.consistency.configuration.AdapterConsistencyConfiguration;

public class RefreshConsistencyRegistrationAction
extends Action {
    private static final String CONTEXT_MENU_NAME = "Refresh consistency registrations (only for internal debugging)";
    private static final String CONTEXT_MENU_ICON = "icons/c4_refresh.png";

    public RefreshConsistencyRegistrationAction() {
        super(CONTEXT_MENU_NAME, AF3ConsistencyUIActivator.getImageDescriptor(CONTEXT_MENU_ICON));
    }

    public void run() {
        boolean isAF3AdapterActive = ConsistencyAdapterEnvironment.isRunning();
        if (!isAF3AdapterActive) {
            String displayHeaderText = "The AF3 consistency adapter is not yet set up and started.\n\nPlease start first the consistency adapter via its menu entry.\nIn addition, make sure that also the central consistency environment is running. If this was not started during AF3 setup or externally via its terminal-based standalone version, you can manually start it as well via the corresponding menu entry.";
            String displayBodyText = "";
            ConsistencyUIUtils.showBasicScrollableInformation(CONTEXT_MENU_NAME, displayHeaderText, displayBodyText);
            return;
        }
        AdapterConsistencyConfiguration config = ConsistencyAdapterEnvironment.getInstance().getConfiguration();
        config.logInfo("Requesting a refresh of the adapter consistency registrations ...");
        ConsistencyAdapterEnvironment.getInstance().refreshAdapterRegistration();
        String displayHeaderText = "Adapter consistency registration was refreshed.";
        String displayBodyText = "";
        config.logInfo(displayHeaderText);
        ConsistencyUIUtils.showBasicScrollableInformation(CONTEXT_MENU_NAME, displayHeaderText, displayBodyText);
        config.logInfo("Requesting a refresh of the central consistency registrations ...");
        boolean isInternalCentralConsistencyActive = CentralConsistencyEnvironment.isRunning();
        if (isInternalCentralConsistencyActive) {
            CentralConsistencyEnvironment env = CentralConsistencyEnvironment.getInstance();
            env.refreshRegistration();
            displayHeaderText = "Central consistency registration was refreshed.";
            config.logInfo(displayHeaderText);
            ConsistencyUIUtils.showBasicScrollableInformation(CONTEXT_MENU_NAME, displayHeaderText, displayBodyText);
        } else {
            displayHeaderText = "Central consistency registration could not be refreshed since no central consistency environment is currently active/reachable.\n\nPlease make sure that the central consistency environment is started and active.";
            config.logWarning(displayHeaderText);
            ConsistencyUIUtils.showBasicScrollableInformation(CONTEXT_MENU_NAME, displayHeaderText, displayBodyText);
        }
    }
}

