/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.consistency.ui.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.concurrent.CancellationException;
import javafx.application.Platform;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fortiss.af3.consistency.ui.AF3ConsistencyUIActivator;
import org.fortiss.af3.consistency.ui.dialog.ChooseResourceDialog;
import org.fortiss.af3.consistency.ui.utils.ConsistencyUIUtils;
import org.fortiss.consistency.CentralConsistencyActivator;

public class StartCentralConsistencyEnvironmentAction
extends Action {
    private static final String CONTEXT_MENU_NAME = "Manually start the central consistency environment inside of AF3";
    private static final String CONTEXT_MENU_ICON = "icons/c4_central_start.png";
    private static final String SHELL_TITLE = "Choose the central consistency resource folder";
    private static final String ENV_NAME = "central consistency environment";

    public StartCentralConsistencyEnvironmentAction() {
        super(CONTEXT_MENU_NAME, AF3ConsistencyUIActivator.getImageDescriptor(CONTEXT_MENU_ICON));
    }

    public void run() {
        CentralConsistencyActivator activator = CentralConsistencyActivator.getDefault();
        StartCentralConsistencyEnvironmentAction.initiateSetupAndStartJob(SHELL_TITLE, CONTEXT_MENU_NAME, ENV_NAME, () -> activator.setUpAndStartCentralConsistencyEnvironment(), path -> activator.setUpAndStartCentralConsistencyEnvironment(path), () -> activator.getLastErrorMessage());
    }

    protected static void initiateSetupAndStartJob(String shellTitle, final String context, final String envName, final SetUpAndStartConsistencyEnvironmentDefault defaultStart, final SetUpAndStartConsistencyEnvironmentResource selectedResStart, final GetLastErrorMessage getErrorMessage) {
        File resourceFolder;
        try {
            resourceFolder = StartCentralConsistencyEnvironmentAction.askForResourceFolder(shellTitle, context, envName);
        }
        catch (CancellationException e) {
            return;
        }
        Job job = new Job("Initiate the " + envName + " and wait for response"){

            protected IStatus run(IProgressMonitor monitor) {
                Job internalJob = null;
                if (resourceFolder == null) {
                    internalJob = defaultStart.run();
                } else {
                    String resourceFolderPath = StartCentralConsistencyEnvironmentAction.checkResourcePath(resourceFolder, context, envName);
                    if (resourceFolderPath != null) {
                        internalJob = selectedResStart.run(resourceFolderPath);
                    }
                }
                if (internalJob != null) {
                    try {
                        internalJob.join();
                        IStatus result = internalJob.getResult();
                        if (result == Status.CANCEL_STATUS) {
                            StartCentralConsistencyEnvironmentAction.warnOfStartCancelation(context, envName, getErrorMessage.run());
                            return result;
                        }
                    }
                    catch (InterruptedException e) {
                        String reason = "The internal job was interrupted by an exception:\n" + e.getMessage();
                        StartCentralConsistencyEnvironmentAction.warnOfStartCancelation(context, envName, reason);
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    private static File askForResourceFolder(String shellTitle, String context, String envName) throws CancellationException {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ChooseResourceDialog resourceChoiceDialog = new ChooseResourceDialog(shell, shellTitle, envName);
        resourceChoiceDialog.open();
        if (!resourceChoiceDialog.goAhead()) {
            String reason = "The dialog for the needed resource folder was canceled.";
            StartCentralConsistencyEnvironmentAction.warnOfStartCancelation(context, envName, reason);
            throw new CancellationException();
        }
        boolean useDefaultResourceFolder = resourceChoiceDialog.useDefault();
        if (useDefaultResourceFolder) {
            return null;
        }
        File resourceFolder = resourceChoiceDialog.getChosenResourceFolder();
        if (resourceFolder == null) {
            String reason = "The selected resource folder is null.";
            StartCentralConsistencyEnvironmentAction.warnOfStartCancelation(context, envName, reason);
            throw new CancellationException();
        }
        return resourceFolder;
    }

    private static String checkResourcePath(File resourceFolder, String context, String envName) {
        boolean existingFolder;
        if (resourceFolder == null) {
            String reason = "The given resource folder is null.";
            StartCentralConsistencyEnvironmentAction.warnOfStartCancelation(context, envName, reason);
            return null;
        }
        boolean bl = existingFolder = Files.exists(resourceFolder.toPath(), new LinkOption[0]) && Files.isDirectory(resourceFolder.toPath(), new LinkOption[0]);
        if (!existingFolder) {
            String reason = "The given resource folder does not exist or is not a folder.";
            StartCentralConsistencyEnvironmentAction.warnOfStartCancelation(context, envName, reason);
            return null;
        }
        try {
            return resourceFolder.getCanonicalPath();
        }
        catch (IOException e) {
            String reason = "The path of the given resource folder could not be converted/extracted.";
            StartCentralConsistencyEnvironmentAction.warnOfStartCancelation(context, envName, reason);
            return null;
        }
    }

    protected static void warnOfStartCancelation(String context, String envName, String reason) {
        String header = "The start of the " + envName + " was canceled. Reason:";
        Platform.runLater(() -> ConsistencyUIUtils.showBasicScrollableInformation(context + " - Failed", header, reason));
    }

    @FunctionalInterface
    static interface GetLastErrorMessage {
        public String run();
    }

    @FunctionalInterface
    static interface SetUpAndStartConsistencyEnvironmentDefault {
        public Job run();
    }

    @FunctionalInterface
    static interface SetUpAndStartConsistencyEnvironmentResource {
        public Job run(String var1);
    }
}

