/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.consistency.ui.commands;

import org.eclipse.jface.action.Action;
import org.fortiss.af3.consistency.AF3ConsistencyActivator;
import org.fortiss.af3.consistency.ui.AF3ConsistencyUIActivator;
import org.fortiss.af3.consistency.ui.commands.StartCentralConsistencyEnvironmentAction;
import org.fortiss.tooling.ext.consistency.ConsistencyAdapterEnvironment;

public class StartConsistencyAdapterEnvironmentAction
extends Action {
    private static final String CONTEXT_MENU_NAME = "Manually start the AF3 consistency adapter environment";
    private static final String CONTEXT_MENU_ICON = "icons/c4_adapter_start.png";
    private static final String SHELL_TITLE = "Choose the internal resource folder for the AF3 adapter";
    private static final String ENV_NAME = "AF3 adapter consistency environment";

    public StartConsistencyAdapterEnvironmentAction() {
        super(CONTEXT_MENU_NAME, AF3ConsistencyUIActivator.getImageDescriptor(CONTEXT_MENU_ICON));
    }

    public void run() {
        boolean isAF3AdapterActive = ConsistencyAdapterEnvironment.isRunning();
        if (isAF3AdapterActive) {
            String reason = "The AF3 consistency adapter was already started.\n\nBefore you can set it up and start it again, you need to shut down the current instance.";
            StartCentralConsistencyEnvironmentAction.warnOfStartCancelation(CONTEXT_MENU_NAME, ENV_NAME, reason);
        }
        AF3ConsistencyActivator activator = AF3ConsistencyActivator.getDefault();
        StartCentralConsistencyEnvironmentAction.initiateSetupAndStartJob(SHELL_TITLE, CONTEXT_MENU_NAME, ENV_NAME, () -> activator.setUpAndStartConsistencyAdapterEnvironment(), path -> activator.setUpAndStartConsistencyAdapterEnvironment(path), () -> activator.getLastErrorMessage());
    }
}

