/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.consistency.ui.commands;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.consistency.ui.commands.TriggerConsistencyCheckBase;
import org.fortiss.af3.consistency.ui.utils.ConsistencyUIUtils;
import org.fortiss.consistency.model.BasicElementInformation;
import org.fortiss.consistency.model.ConsistencyModelElementFactory;
import org.fortiss.consistency.model.communication.TriggerFeedback;
import org.fortiss.consistency.model.communication.UserInitialInformation;
import org.fortiss.tooling.ext.consistency.ConsistencyAdapterEnvironment;
import org.fortiss.tooling.ext.consistency.configuration.AdapterConsistencyConfiguration;

public class TriggerConsistencyCheckAction
extends TriggerConsistencyCheckBase {
    private static final String CONTEXT_MENU_NAME = "Trigger consistency check";

    public TriggerConsistencyCheckAction(EObject element) {
        super(element, CONTEXT_MENU_NAME);
    }

    public void run() {
        TriggerFeedback feedback;
        BasicElementInformation selectedElementInfo;
        boolean isAF3AdapterActive = ConsistencyAdapterEnvironment.isRunning();
        if (!isAF3AdapterActive) {
            String displayHeaderText = "The AF3 consistency adapter is not yet set up and started.\n\nPlease start first the consistency adapter via its menu entry.\nIn addition, make sure that also the central consistency environment is running. If this was not started during AF3 setup or externally via its terminal-based standalone version, you can manually start it as well via the corresponding menu entry.";
            String displayBodyText = "";
            ConsistencyUIUtils.showBasicScrollableInformation(CONTEXT_MENU_NAME, displayHeaderText, displayBodyText);
            return;
        }
        ConsistencyAdapterEnvironment adapterEnvironment = ConsistencyAdapterEnvironment.getInstance();
        AdapterConsistencyConfiguration config = adapterEnvironment.getConfiguration();
        try {
            selectedElementInfo = TriggerConsistencyCheckAction.getInformationBundleOfElement(this.getSelectedElement(), config.getOwnIdentifier());
        }
        catch (Exception e) {
            String displayHeaderText = "An error occured during the setup of the check request, which is why the check will not be continued.\nError message:";
            String displayBodyText = e.getMessage();
            ConsistencyUIUtils.showBasicScrollableInformation(CONTEXT_MENU_NAME, displayHeaderText, displayBodyText);
            return;
        }
        ArrayList<BasicElementInformation> startingPointElementsInfo = new ArrayList<BasicElementInformation>();
        startingPointElementsInfo.add(selectedElementInfo);
        String userToken = null;
        String location = null;
        UserInitialInformation userInfo = ConsistencyModelElementFactory.createUserInitialInformation(userToken, location);
        String exceptionMessage = "";
        try {
            feedback = adapterEnvironment.getConsistencyAdapterClient().triggerConsistencyCheck(startingPointElementsInfo, userInfo);
        }
        catch (Exception e) {
            exceptionMessage = e.getMessage();
            feedback = null;
        }
        if (feedback == null) {
            String displayHeaderText = "Requesting consistency check was unsuccessful.\n\nWas the AF3 consistency adapter correctly set up and is the central consistency environment successfully running?";
            String displayBodyText = exceptionMessage;
            config.logError(displayHeaderText + "\n");
            ConsistencyUIUtils.showBasicScrollableInformation(CONTEXT_MENU_NAME, displayHeaderText, displayBodyText);
            return;
        }
        TriggerConsistencyCheckAction.presentConsistencyFeedbackToUser(feedback);
    }
}

