/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.consistency.ui.commands;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.fortiss.af3.consistency.ui.AF3ConsistencyUIActivator;
import org.fortiss.af3.consistency.ui.utils.ConsistencyUIUtils;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.consistency.exceptions.FailedConsistencyCheckException;
import org.fortiss.consistency.model.BasicElementInformation;
import org.fortiss.consistency.model.ConsistencyModelElementFactory;
import org.fortiss.consistency.model.ConsistencyRule;
import org.fortiss.consistency.model.ConsistencyViolation;
import org.fortiss.consistency.model.ContextWrapper;
import org.fortiss.consistency.model.communication.TriggerFeedback;
import org.fortiss.tooling.ext.consistency.ConsistencyAdapterEnvironment;
import org.fortiss.tooling.ext.consistency.configuration.AdapterConsistencyConfiguration;
import org.fortiss.tooling.ext.consistency.service.IConsistencyProviderService;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public abstract class TriggerConsistencyCheckBase
extends Action {
    private static final String CONTEXT_MENU_ICON = "icons/c4_check.png";
    private static final String FEEDBACK_SHELL_TITLE = "Consistency Feedback";
    private final EObject selectedElement;

    public TriggerConsistencyCheckBase(EObject element, String contextMenuName) {
        super(contextMenuName, AF3ConsistencyUIActivator.getImageDescriptor(CONTEXT_MENU_ICON));
        this.selectedElement = element;
    }

    protected EObject getSelectedElement() {
        return this.selectedElement;
    }

    protected static void presentConsistencyFeedbackToUser(TriggerFeedback feedback) {
        if (feedback == null) {
            return;
        }
        int consideredRulesCounter = feedback.getConsideredRulesCounter();
        int selectedRulesCounter = feedback.getSelectedRulesCounter();
        int performedEvaluationsCounter = feedback.getPerformedEvaluationsCounter();
        EList foundViolations = feedback.getFoundViolations();
        Object displayHeaderText = "For the provided selection, ";
        if (performedEvaluationsCounter == 0) {
            displayHeaderText = (String)displayHeaderText + "not a single consistency evaluation was performed.";
            displayHeaderText = foundViolations.isEmpty() ? (String)displayHeaderText + "\n\nAre there any consistency rules defined for the selected model elements and were the selected model elements registered for the consistency environment?\nIn case you do not know what this means, ask your consistency manager/developer." : (String)displayHeaderText + "\nThis is due to:";
        } else {
            displayHeaderText = (String)displayHeaderText + performedEvaluationsCounter + " evaluations were performed in total. " + selectedRulesCounter + " consistency rules were selected for possible (re-)evaluation from a total of " + consideredRulesCounter + " consistency rules.\nFound consistency violations: ";
            displayHeaderText = foundViolations.isEmpty() ? (String)displayHeaderText + "None!\nYour model environment is consistent based on the defined consistency rules." : (String)displayHeaderText + foundViolations.size() + " (details below)";
        }
        Object displayBodyText = "";
        int n = 1;
        for (ConsistencyViolation violation : foundViolations) {
            displayBodyText = (String)displayBodyText + "\n" + n + ". Violation:";
            displayBodyText = (String)displayBodyText + "\n- Name: " + violation.getName();
            displayBodyText = (String)displayBodyText + "\n- Type: " + String.valueOf(violation.getViolationType());
            displayBodyText = (String)displayBodyText + "\n- Type explanation: " + violation.getViolationTypeExplanation();
            ConsistencyRule rule = violation.getViolatedRule();
            if (rule == null) {
                displayBodyText = (String)displayBodyText + "\n- Violated rule: Hidden or not existent";
            } else {
                displayBodyText = (String)displayBodyText + "\n- Violated rule: '" + rule.getName() + "' (UUID: " + rule.getUuid() + ")";
                displayBodyText = (String)displayBodyText + "\n\t* Comment: '" + rule.getComment() + "'";
                displayBodyText = (String)displayBodyText + "\n\t* Original Condition: " + rule.getRuleCondition().getOriginalExpression();
                displayBodyText = (String)displayBodyText + "\n\t* Modified Condition: " + rule.getRuleCondition().getModifiedExpression();
            }
            displayBodyText = (String)displayBodyText + "\n- Cause: " + violation.getCause();
            ContextWrapper wrapper = violation.getUsedContextData();
            if (wrapper == null) {
                displayBodyText = (String)displayBodyText + "\n- Context data: Hidden or not existent";
            } else {
                EMap contextElementsMap = wrapper.getContextElements();
                displayBodyText = (String)displayBodyText + "\n- Context data:";
                for (Map.Entry entry : contextElementsMap.entrySet()) {
                    displayBodyText = (String)displayBodyText + "\n\t* Identifier in rule: '" + (String)entry.getKey() + "', Object: " + String.valueOf(entry.getValue());
                }
            }
            displayBodyText = (String)displayBodyText + "\n";
            ++n;
        }
        AdapterConsistencyConfiguration config = ConsistencyAdapterEnvironment.getInstance().getConfiguration();
        config.logInternal((String)displayHeaderText + "\n" + (String)displayBodyText);
        ConsistencyUIUtils.showBasicScrollableInformation(FEEDBACK_SHELL_TITLE, (String)displayHeaderText, (String)displayBodyText);
    }

    protected static BasicElementInformation getInformationBundleOfElement(EObject element, String adapterIdentifier) throws FailedConsistencyCheckException {
        String elementClassName = "Element class not found";
        String translatedClassName = IConsistencyProviderService.getInstance().getConsistencyClassNameForToolClass(element.getClass());
        if (translatedClassName == null) {
            String exceptionMessage = "A matching class inside the consistency environment (viewtype collection) could not be found for this AF3 class: '" + element.getClass().getCanonicalName() + "'.\nTherefore, it is not possible to continue the consistency check for the selected element.\n\nIf you want to make consistency checks for this element type in the future, please reach out to the AF3 developer team to implement a consistency provider for this element type or do it yourself by checking out the already existing consistency providers in the AF3 open source code (as templates).";
            throw new FailedConsistencyCheckException(exceptionMessage);
        }
        elementClassName = translatedClassName;
        String elementName = "Element name not found";
        if (element instanceof INamedElement) {
            elementName = ((INamedElement)element).getName();
        } else if (element instanceof FunctionDefinition) {
            elementName = ((FunctionDefinition)element).getFunction().getName();
        }
        String elementId = "Element ID not found";
        if (element instanceof IIdLabeled) {
            elementId = String.valueOf(((IIdLabeled)element).getId());
        }
        String modelName = "Model name not found";
        EList parentList = EcoreUtils.getParentsWithType((EObject)element, INamedCommentedElement.class);
        if (parentList != null && !parentList.isEmpty()) {
            INamedCommentedElement root = (INamedCommentedElement)parentList.get(parentList.size() - 1);
            modelName = root.getName();
        } else if (element instanceof INamedCommentedElement) {
            modelName = ((INamedCommentedElement)element).getName();
        }
        return ConsistencyModelElementFactory.createFullBasicElementInformation((String)elementClassName, (String)elementName, (String)elementId, (String)modelName, (String)adapterIdentifier);
    }
}

