/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.consistency.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import org.conqat.ide.commons.ui.dialog.MessageUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.consistency.ui.commands.TriggerConsistencyCheckBase;
import org.fortiss.af3.consistency.ui.utils.ConsistencyUIUtils;
import org.fortiss.consistency.model.BasicElementInformation;
import org.fortiss.consistency.model.ConsistencyModelElementFactory;
import org.fortiss.consistency.model.communication.TriggerFeedback;
import org.fortiss.consistency.model.communication.UserInitialInformation;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.ext.consistency.ConsistencyAdapterEnvironment;
import org.fortiss.tooling.ext.consistency.configuration.AdapterConsistencyConfiguration;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class TriggerRecursiveConsistencyCheckAction
extends TriggerConsistencyCheckBase {
    private static final String CONTEXT_MENU_NAME = "Trigger recursive consistency check";

    public TriggerRecursiveConsistencyCheckAction(EObject element) {
        super(element, CONTEXT_MENU_NAME);
    }

    public void run() {
        TriggerFeedback feedback;
        boolean isAF3AdapterActive = ConsistencyAdapterEnvironment.isRunning();
        if (!isAF3AdapterActive) {
            String displayHeaderText = "The AF3 consistency adapter is not yet set up and started.\n\nPlease start first the consistency adapter via its menu entry.\nIn addition, make sure that also the central consistency environment is running. If this was not started during AF3 setup or externally via its terminal-based standalone version, you can manually start it as well via the corresponding menu entry.";
            String displayBodyText = "";
            ConsistencyUIUtils.showBasicScrollableInformation(CONTEXT_MENU_NAME, displayHeaderText, displayBodyText);
            return;
        }
        ConsistencyAdapterEnvironment adapterEnvironment = ConsistencyAdapterEnvironment.getInstance();
        AdapterConsistencyConfiguration config = adapterEnvironment.getConfiguration();
        EObject selecetdElement = this.getSelectedElement();
        EList selectedElementChildren = EcoreUtils.getChildrenWithType((EObject)selecetdElement, IModelElement.class);
        ArrayList<EObject> elementsToCheck = new ArrayList<EObject>();
        elementsToCheck.add(selecetdElement);
        elementsToCheck.addAll((Collection<EObject>)selectedElementChildren);
        String title = "Confirm number of elements for checking";
        String message = "You have selected " + elementsToCheck.size() + " elements for consistency checking. Do you want to continue?";
        boolean confirmed = MessageUtils.confirm((String)title, (String)message);
        if (!confirmed) {
            return;
        }
        ArrayList<BasicElementInformation> startingPointElementsInfo = new ArrayList<BasicElementInformation>();
        Object displayBodyText = "";
        int errorCounter = 0;
        for (EObject element : elementsToCheck) {
            BasicElementInformation selectedElementInfo;
            try {
                selectedElementInfo = TriggerRecursiveConsistencyCheckAction.getInformationBundleOfElement(element, config.getOwnIdentifier());
            }
            catch (Exception e) {
                ++errorCounter;
                String elementName = element.toString();
                if (element instanceof INamedElement) {
                    elementName = ((INamedElement)element).getName();
                }
                displayBodyText = (String)displayBodyText + "Error " + errorCounter + " (for element '" + elementName + "' of class '" + element.getClass().getSimpleName() + "'):\n" + e.getMessage() + "\n\n****************\n\n";
                continue;
            }
            startingPointElementsInfo.add(selectedElementInfo);
        }
        if (errorCounter > 0) {
            Object displayHeaderText = errorCounter + " errors";
            if (errorCounter == 1) {
                displayHeaderText = "One error";
            }
            displayHeaderText = (String)displayHeaderText + " occured:\n";
            int remainingElements = elementsToCheck.size() - errorCounter;
            if (remainingElements > 0) {
                displayHeaderText = (String)displayHeaderText + "(for all other " + remainingElements + " selected elements without errors, the recursive check will still be executed!)";
            }
            ConsistencyUIUtils.showBasicScrollableInformation(CONTEXT_MENU_NAME, (String)displayHeaderText, (String)displayBodyText);
        }
        String userToken = null;
        String location = null;
        UserInitialInformation userInfo = ConsistencyModelElementFactory.createUserInitialInformation(userToken, location);
        String exceptionMessage = "";
        try {
            feedback = adapterEnvironment.getConsistencyAdapterClient().triggerConsistencyCheck(startingPointElementsInfo, userInfo);
        }
        catch (Exception e) {
            exceptionMessage = e.getMessage();
            feedback = null;
        }
        if (feedback == null) {
            String displayHeaderText = "Requesting consistency check was unsuccessful.\n\nWas the AF3 consistency adapter correctly set up and is the central consistency environment successfully running?";
            displayBodyText = exceptionMessage;
            config.logError(displayHeaderText + "\n");
            ConsistencyUIUtils.showBasicScrollableInformation(CONTEXT_MENU_NAME, displayHeaderText, (String)displayBodyText);
            return;
        }
        TriggerRecursiveConsistencyCheckAction.presentConsistencyFeedbackToUser(feedback);
    }
}

