/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.consistency.ui.dialog;

import java.io.File;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ChooseResourceDialog
extends Dialog {
    private static final int DIALOG_WINDOW_WIDTH_PREF = 650;
    private static final int DIALOG_WINDOW_HEIGHT_PREF = 250;
    private static final int OWN_PATH_BUTTON_ID = 100;
    private String title;
    private String envName;
    private boolean goAhead = false;
    private boolean useDefault = true;
    private File selectedResourceFolder = null;

    public ChooseResourceDialog(Shell parentShell, String dialogTitle, String envName) {
        super(parentShell);
        this.title = dialogTitle;
        this.envName = envName;
        this.setShellStyle(32);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 100) {
            this.selectFolder();
        }
    }

    protected void okPressed() {
        this.goAhead = true;
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        GridData layoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
        int gapToBorder = 50;
        layoutData.widthHint = 650 - gapToBorder;
        Label initText = new Label(container, 64);
        initText.setLayoutData((Object)layoutData);
        initText.setText("For setting up the " + this.envName + ", a resource folder is needed where the initial configuration is defined.");
        Label defaultText = new Label(container, 64);
        defaultText.setLayoutData((Object)layoutData);
        defaultText.setText("Do you want to use the default resource folder?");
        Label selectText = new Label(container, 64);
        selectText.setLayoutData((Object)layoutData);
        selectText.setText("Otherwise, you have to select your own resource folder ...");
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL + " (default resource folder)", true);
        this.createButton(parent, 100, "Select own resource folder", false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(650, 250);
    }

    protected void selectFolder() {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        directoryChooser.setInitialDirectory(workspacePath.toFile());
        directoryChooser.setTitle("Select your own resource folder");
        this.selectedResourceFolder = directoryChooser.showDialog((Window)new Stage());
        if (this.selectedResourceFolder != null) {
            this.useDefault = false;
            this.goAhead = true;
            super.okPressed();
        }
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public boolean useDefault() {
        return this.useDefault;
    }

    public File getChosenResourceFolder() {
        return this.selectedResourceFolder;
    }
}

