/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.consistency.ui.menus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.util.Pair;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.fortiss.af3.consistency.ui.AF3ConsistencyUIActivator;
import org.fortiss.af3.consistency.ui.commands.RefreshConsistencyRegistrationAction;
import org.fortiss.af3.consistency.ui.commands.StartCentralConsistencyEnvironmentAction;
import org.fortiss.af3.consistency.ui.commands.StartConsistencyAdapterEnvironmentAction;
import org.fortiss.af3.consistency.ui.commands.StopCentralConsistencyEnvironmentAction;
import org.fortiss.af3.consistency.ui.commands.StopConsistencyAdapterEnvironmentAction;
import org.fortiss.af3.consistency.ui.commands.TriggerConsistencyCheckAction;
import org.fortiss.af3.consistency.ui.commands.TriggerRecursiveConsistencyCheckAction;
import org.fortiss.consistency.CentralConsistencyEnvironment;
import org.fortiss.tooling.ext.consistency.ConsistencyAdapterEnvironment;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.service.INavigatorService;

public class ConsistencySubContextMenu
implements IContextMenuContributor {
    private static final String CONTEXT_MENU_NAME = "Consistency Manager";
    private static final String MANAGEMENT_MENU_NAME = "Environment Management";
    private static final String CONTEXT_MENU_ICON = "icons/c4_logo.png";
    private static final String MANAGEMENT_MENU_ICON = "icons/c4_management.png";

    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        boolean isExpertMode = INavigatorService.getInstance().isExpertViewActive();
        if (isExpertMode && selection != null) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            boolean isInternalCentralConsistencyActive = CentralConsistencyEnvironment.isRunning();
            boolean isAF3AdapterActive = ConsistencyAdapterEnvironment.isRunning();
            MenuManager consistencyManagerMenu = new MenuManager();
            consistencyManagerMenu.setMenuText(CONTEXT_MENU_NAME);
            consistencyManagerMenu.setImageDescriptor(AF3ConsistencyUIActivator.getImageDescriptor(CONTEXT_MENU_ICON));
            MenuManager environmentManagementMenu = new MenuManager();
            environmentManagementMenu.setMenuText(MANAGEMENT_MENU_NAME);
            environmentManagementMenu.setImageDescriptor(AF3ConsistencyUIActivator.getImageDescriptor(MANAGEMENT_MENU_ICON));
            ArrayList<Pair> environmentManagementMenuActionPairs = new ArrayList<Pair>();
            environmentManagementMenuActionPairs.add(new Pair((Object)new StartCentralConsistencyEnvironmentAction(), (Object)(!isInternalCentralConsistencyActive ? 1 : 0)));
            environmentManagementMenuActionPairs.add(new Pair((Object)new StartConsistencyAdapterEnvironmentAction(), (Object)(!isAF3AdapterActive ? 1 : 0)));
            environmentManagementMenuActionPairs.add(new Pair((Object)new StopCentralConsistencyEnvironmentAction(), (Object)isInternalCentralConsistencyActive));
            environmentManagementMenuActionPairs.add(new Pair((Object)new StopConsistencyAdapterEnvironmentAction(), (Object)isAF3AdapterActive));
            environmentManagementMenuActionPairs.add(new Pair((Object)new RefreshConsistencyRegistrationAction(), (Object)(isInternalCentralConsistencyActive && isAF3AdapterActive ? 1 : 0)));
            for (Pair environmentManagementMenuActionPair : environmentManagementMenuActionPairs) {
                IAction environmentManagementMenuAction = (IAction)environmentManagementMenuActionPair.getKey();
                environmentManagementMenuAction.setEnabled(((Boolean)environmentManagementMenuActionPair.getValue()).booleanValue());
                ActionContributionItem environmentManagementMenuItem = new ActionContributionItem(environmentManagementMenuAction);
                environmentManagementMenu.add((IContributionItem)environmentManagementMenuItem);
            }
            ArrayList<Pair> consistencyManagerMenuActionPairs = new ArrayList<Pair>();
            consistencyManagerMenuActionPairs.add(new Pair((Object)new TriggerConsistencyCheckAction(selection), (Object)isAF3AdapterActive));
            consistencyManagerMenuActionPairs.add(new Pair((Object)new TriggerRecursiveConsistencyCheckAction(selection), (Object)isAF3AdapterActive));
            for (Pair consistencyManagerMenuActionPair : consistencyManagerMenuActionPairs) {
                IAction consistencyManagerMenuAction = (IAction)consistencyManagerMenuActionPair.getKey();
                consistencyManagerMenuAction.setEnabled(((Boolean)consistencyManagerMenuActionPair.getValue()).booleanValue());
                ActionContributionItem consistencyManagerMenuItem = new ActionContributionItem(consistencyManagerMenuAction);
                consistencyManagerMenu.add((IContributionItem)consistencyManagerMenuItem);
            }
            consistencyManagerMenu.add((IContributionItem)environmentManagementMenu);
            contributionItems.add((IContributionItem)consistencyManagerMenu);
            return contributionItems;
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "beforeglobal";
    }
}

