/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.consistency.ui.utils;

import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import org.fortiss.af3.consistency.ui.AF3ConsistencyUIActivator;
import org.fortiss.tooling.common.ui.javafx.util.GraphicUtils;

public class ConsistencyUIUtils {
    private static final Double DIALOG_WINDOW_WIDTH_PREF = 700.0;
    private static final Double DIALOG_WINDOW_HEIGHT_PREF = 500.0;

    public static void showBasicScrollableInformation(String windowTitle, String headerText, String bodyText) {
        boolean showSymbol = true;
        ConsistencyUIUtils.showCustomScrollableAlert(Alert.AlertType.INFORMATION, windowTitle, headerText, bodyText, showSymbol, DIALOG_WINDOW_WIDTH_PREF, DIALOG_WINDOW_HEIGHT_PREF);
    }

    public static void showCustomScrollableAlert(Alert.AlertType alertType, String windowTitle, String headerText, String bodyText, boolean showSymbol, Double windowPrefWidth, Double windowPrefHeight) {
        Alert alert = new Alert(alertType);
        if (!showSymbol) {
            alert.setGraphic(null);
        }
        alert.setTitle(windowTitle);
        alert.setHeaderText(headerText);
        alert.setResizable(true);
        DialogPane dialogPane = alert.getDialogPane();
        Image taskbarIcon = GraphicUtils.getFXImage((String)AF3ConsistencyUIActivator.PLUGIN_ID, (String)"icons/c4_logo.png");
        Stage stage = (Stage)dialogPane.getScene().getWindow();
        stage.getIcons().add((Object)taskbarIcon);
        if (!bodyText.isBlank()) {
            TextArea area = new TextArea(bodyText);
            area.setWrapText(true);
            area.setEditable(false);
            dialogPane.setContent((Node)area);
        }
        if (windowPrefWidth != null && windowPrefWidth > 0.0) {
            dialogPane.setPrefWidth(windowPrefWidth.doubleValue());
        }
        if (windowPrefHeight != null && windowPrefHeight > 0.0 && !bodyText.isBlank()) {
            dialogPane.setPrefHeight(windowPrefHeight.doubleValue());
        }
        alert.showAndWait();
    }
}

