/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.timing.approximation;

import org.fortiss.af3.component.model.generator.ComponentFunction;
import org.fortiss.af3.component.model.generator.ComponentProgram;
import org.fortiss.af3.component.model.generator.LocalFunction;
import org.fortiss.af3.component.model.generator.port.NoValArgument;
import org.fortiss.af3.component.model.generator.port.PortArgument;
import org.fortiss.af3.component.model.generator.port.PortVariableOperationArgument;
import org.fortiss.af3.component.model.generator.port.ReadPortVariableExpression;
import org.fortiss.af3.component.model.generator.port.TestPortVariableExpression;
import org.fortiss.af3.component.model.generator.port.ValueArgument;
import org.fortiss.af3.component.model.generator.port.WritePortVariableStatement;
import org.fortiss.af3.component.utils.ComponentProgramUtils;
import org.fortiss.af3.expression.generator.TermReplacementVisitor;
import org.fortiss.af3.expression.model.terms.Const;
import org.fortiss.af3.expression.model.terms.EOperator;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IntConst;
import org.fortiss.af3.expression.model.terms.PredefinedFunction;
import org.fortiss.af3.expression.model.terms.UserdefinedFunction;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.terms.imperative.Comment;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.IfThenElse;
import org.fortiss.af3.expression.model.terms.imperative.Return;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.timing.approximation.ApproximationResult;
import org.fortiss.af3.timing.approximation.ImperativeProgramApproximationWeights;

class ImperativeProgramApproximationAnalysis
extends TermReplacementVisitor {
    private int result;
    private ComponentProgram source;

    public ImperativeProgramApproximationAnalysis(ComponentFunction stepFunction, ComponentProgram source) {
        super((ITerm)stepFunction.getDefinition());
        this.source = source;
        this.result = ((IntConst)this.apply()).getValue();
    }

    protected ITerm applyInternal(ITerm term) {
        if (term instanceof WritePortVariableStatement) {
            return this.setPortCode((WritePortVariableStatement)term);
        }
        if (term instanceof TestPortVariableExpression) {
            return this.testPortCode((TestPortVariableExpression)term);
        }
        if (term instanceof ReadPortVariableExpression) {
            return this.getPortCode((ReadPortVariableExpression)term);
        }
        return super.applyInternal(term);
    }

    public ApproximationResult getResult() {
        return new ApproximationResult(this.result);
    }

    protected ITerm applyToConst(Const term) {
        return ExpressionModelElementFactory.intConst((int)1);
    }

    protected ITerm applyToVar(Var term) {
        return ExpressionModelElementFactory.intConst((int)2);
    }

    protected ITerm applyToStatementSequence(StatementSequence seq) {
        int sum = 0;
        for (IStatementTerm stmt : seq.getStatements()) {
            IntConst val = (IntConst)this.applyInternal((ITerm)stmt);
            sum += val.getValue();
        }
        return ExpressionModelElementFactory.intConst((int)sum);
    }

    protected ITerm applyToAssignment(Assignment assign) {
        int val = ((IntConst)this.applyInternal((ITerm)assign.getValue())).getValue() + 3;
        return ExpressionModelElementFactory.intConst((int)val);
    }

    protected ITerm applyToComment(Comment comment) {
        return ExpressionModelElementFactory.intConst((int)0);
    }

    protected ITerm applyToReturn(Return ret) {
        int val = 3;
        if (ret.getValue() != null) {
            val += ((IntConst)this.applyInternal((ITerm)ret.getValue())).getValue();
        }
        return ExpressionModelElementFactory.intConst((int)val);
    }

    protected ITerm applyToIfThenElse(IfThenElse term) {
        IntConst ic;
        int val = ((IntConst)this.applyInternal((ITerm)term.getGuard())).getValue();
        int subVal = 0;
        if (term.getThenBlock() != null) {
            ic = (IntConst)this.applyInternal((ITerm)term.getThenBlock());
            subVal = ic.getValue();
        }
        if (term.getElseBlock() != null && (ic = (IntConst)this.applyInternal((ITerm)term.getElseBlock())).getValue() > subVal) {
            subVal = ic.getValue();
        }
        return ExpressionModelElementFactory.intConst((int)(val + subVal));
    }

    protected ITerm applyToFunctionCall(FunctionCall call) {
        int argValue = 0;
        for (ITerm arg : call.getArguments()) {
            argValue += ((IntConst)this.applyInternal(arg)).getValue();
        }
        if (call.getFunction() instanceof PredefinedFunction) {
            EOperator op = ((PredefinedFunction)call.getFunction()).getOperator();
            return ExpressionModelElementFactory.intConst((int)ImperativeProgramApproximationWeights.getPredefinedOperatorWeight(op, argValue));
        }
        UserdefinedFunction udef = (UserdefinedFunction)call.getFunction();
        ComponentFunction calledFun = ComponentProgramUtils.findComponentFunctionByName((String)udef.getName(), (ComponentProgram)this.source);
        if (calledFun != null) {
            int funBody = ((IntConst)this.applyInternal((ITerm)calledFun.getDefinition())).getValue();
            return ExpressionModelElementFactory.intConst((int)ImperativeProgramApproximationWeights.getUserdefinedFunctionWeight(call, argValue, funBody));
        }
        LocalFunction calledLocal = ComponentProgramUtils.findLocalFunctionByName((String)udef.getName(), (ComponentProgram)this.source);
        if (calledLocal != null) {
            int funBody = ((IntConst)this.applyInternal((ITerm)calledLocal.getDefinition())).getValue();
            return ExpressionModelElementFactory.intConst((int)ImperativeProgramApproximationWeights.getUserdefinedFunctionWeight(call, argValue, funBody));
        }
        return ExpressionModelElementFactory.intConst((int)0);
    }

    private ITerm setPortCode(WritePortVariableStatement term) {
        if (term.getArgument() instanceof NoValArgument) {
            return ExpressionModelElementFactory.intConst((int)3);
        }
        if (term.getArgument() instanceof PortArgument) {
            return ExpressionModelElementFactory.intConst((int)10);
        }
        ValueArgument valArg = (ValueArgument)term.getArgument();
        int valArgWeight = ((IntConst)this.applyInternal((ITerm)valArg.getValue())).getValue();
        return ExpressionModelElementFactory.intConst((int)ImperativeProgramApproximationWeights.getSetPortValueWeight(valArgWeight));
    }

    private ITerm testPortCode(TestPortVariableExpression term) {
        PortVariableOperationArgument arg = term.getArgument();
        if (arg instanceof NoValArgument) {
            return ExpressionModelElementFactory.intConst((int)1);
        }
        if (arg instanceof PortArgument) {
            return ExpressionModelElementFactory.intConst((int)5);
        }
        ValueArgument valueArg = (ValueArgument)arg;
        int value = ((IntConst)this.applyInternal((ITerm)valueArg.getValue())).getValue();
        return ExpressionModelElementFactory.intConst((int)ImperativeProgramApproximationWeights.getTestPortValueWeight(value));
    }

    private ITerm getPortCode(ReadPortVariableExpression term) {
        return ExpressionModelElementFactory.intConst((int)1);
    }
}

