/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.timing.compose;

import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.timing.model.Event;
import org.fortiss.af3.timing.model.EventChain;
import org.fortiss.af3.timing.model.EventChainConstraint;
import org.fortiss.tooling.base.compose.ModelElementCompositorBase;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class EventChainConstraintCompositor
extends ModelElementCompositorBase<EventChain> {
    public boolean compose(EventChain container, EObject contained, IElementCompositionContext context) {
        boolean rval = super.compose((EObject)container, contained, context);
        container.getConstraints().add((Object)((EventChainConstraint)contained));
        return rval;
    }

    private <T extends EventChainConstraint> T getFirstEventChainConstraint(EventChain eventChain, Class<T> constraintType) {
        return (T)((EventChainConstraint)EcoreUtils.pickFirstInstanceOf(constraintType, eventChain.getConstraints()));
    }

    private Stream<EventChain> getMostRefinedEventChains(EventChain eventChain, Class<? extends EventChainConstraint> constraintType) {
        int i = 0;
        EList<EventChain> subChains = eventChain.getSubchains();
        for (EventChain subChain : subChains) {
            if (this.getFirstEventChainConstraint(subChain, constraintType) == null) break;
            ++i;
        }
        if (i < subChains.size()) {
            return Stream.of(eventChain);
        }
        return subChains.stream().map(s -> this.getMostRefinedEventChains((EventChain)s, constraintType)).flatMap(s -> s);
    }

    public boolean canCompose(EventChain eventChain, EObject contained, IElementCompositionContext context) {
        if (!this.isCorrectElementClass(contained)) {
            return false;
        }
        Class<?> constraintType = ((EventChainConstraint)contained).getClass();
        if (this.getFirstEventChainConstraint(eventChain, constraintType) != null) {
            return false;
        }
        Event stimulus = eventChain.getStimulus();
        if (stimulus == null || stimulus.getEntity() == null) {
            return false;
        }
        Event response = eventChain.getResponse();
        if (response == null || response.getEntity() == null) {
            return false;
        }
        EventChain parentChain = eventChain.getParentChain();
        return parentChain == null || this.getMostRefinedEventChains(eventChain.getRootChain(), constraintType).anyMatch(c -> c == parentChain);
    }

    public boolean canComposePrototype(Prototype prototype) {
        return this.isCorrectElementClass(prototype.getPrototype());
    }

    public boolean canDecompose(EObject contained) {
        if (!this.isCorrectElementClass(contained)) {
            return false;
        }
        EventChain eventChain = ((EventChainConstraint)contained).getEventChain();
        return eventChain.getSubchains().isEmpty() || EcoreUtils.getChildrenWithType((EObject)eventChain, contained.getClass()).size() == 1;
    }

    private boolean isCorrectElementClass(EObject contained) {
        return contained instanceof EventChainConstraint;
    }
}

