/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.timing.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fortiss.af3.timing.ITimingSpecificationService;
import org.fortiss.af3.timing.model.EntityEvent;
import org.fortiss.af3.timing.model.Event;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.types.EMFTypeMap;
import org.fortiss.tooling.kernel.service.types.EMFTypeToTypeSetMap;

public class TimingSpecificationService
implements ITimingSpecificationService,
IIntrospectiveKernelService {
    private EMFTypeToTypeSetMap<EntityEvent, IModelElement> entityEventElementTypeMap = new EMFTypeToTypeSetMap();
    private EMFTypeMap<Event, String> eventTypeNameMap = new EMFTypeMap();
    private Map<String, Class<? extends Event>> nameEventTypeMap = new HashMap<String, Class<? extends Event>>();
    private Set<Class<? extends IProjectRootElement>> rootElementTypes = new HashSet<Class<? extends IProjectRootElement>>();
    private static final TimingSpecificationService INSTANCE = new TimingSpecificationService();

    public static TimingSpecificationService getInstance() {
        return INSTANCE;
    }

    @Override
    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService((IIntrospectiveKernelService)this);
    }

    @Override
    public void initializeService() {
    }

    @Override
    public void addEntityEventElementType(Class<? extends EntityEvent> eventType, Class<? extends IModelElement> elementType) {
        this.entityEventElementTypeMap.addTypeSetEntry(eventType, elementType);
    }

    @Override
    public Collection<Class<? extends EntityEvent>> getEntityEventTypes() {
        return this.entityEventElementTypeMap.getSourceTypes();
    }

    @Override
    public Collection<Class<? extends IModelElement>> getElementTypes(Class<? extends EntityEvent> eventType) {
        return this.entityEventElementTypeMap.getTargetTypes(eventType);
    }

    @Override
    public void addRootElementType(Class<? extends IProjectRootElement> rootElementType) {
        this.rootElementTypes.add(rootElementType);
    }

    @Override
    public Collection<Class<? extends IProjectRootElement>> getRootElementTypes() {
        return Collections.unmodifiableCollection(this.rootElementTypes);
    }

    @Override
    public void addEventTypeName(Class<? extends Event> eventType, String name) {
        String currentName = (String)this.eventTypeNameMap.get(eventType);
        if (currentName != null) {
            throw new RuntimeException("Cannot register name \"" + name + "\" for event type " + eventType.getSimpleName() + ". Name \"" + currentName + "\" has already been registered.");
        }
        this.eventTypeNameMap.put(eventType, (Object)name);
        Class<? extends Event> currentEventType = this.nameEventTypeMap.get(name);
        if (currentEventType != null) {
            throw new RuntimeException("Cannot register " + eventType.getSimpleName() + " under name \"" + name + "\". It has already been assigned to \"" + currentEventType.getSimpleName() + "\".");
        }
        this.nameEventTypeMap.put(name, eventType);
    }

    @Override
    public String getEventTypeName(Class<? extends Event> eventType) {
        String name = (String)this.eventTypeNameMap.get(eventType);
        return name != null ? name : eventType.getSimpleName();
    }

    @Override
    public Class<? extends Event> getEventType(String name) {
        return this.nameEventTypeMap.get(name);
    }

    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThe service The timing specification service allows to configure admissible combinations of events, timing constraints, and model elements.";
    }

    public String getIntrospectionLabel() {
        return "Timing Specification Service";
    }

    public IIntrospectionDetailsItem getDetailsItem() {
        return null;
    }

    public boolean showInIntrospectionNavigation() {
        return true;
    }

    public Collection<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }
}

