/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.timing.model.impl;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.fortiss.af3.timing.model.EntityEvent;
import org.fortiss.af3.timing.model.Event;
import org.fortiss.af3.timing.model.EventChain;
import org.fortiss.af3.timing.model.EventConstraint;
import org.fortiss.af3.timing.model.EventReference;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.af3.timing.model.impl.TimingSpecificationImpl;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class TimingSpecificationStaticImpl {
    public static EList<Event> getEvents(TimingSpecification ts) {
        return ts.getEventsContainer().getEvents();
    }

    public static <T extends EntityEvent> T getEvent(TimingSpecification ts, IModelElement element, Class<T> eventType) {
        EList events = EcoreUtils.pickInstanceOf(eventType, TimingSpecificationStaticImpl.getEvents(ts, element));
        if (events.size() > 1) {
            throw new RuntimeException("More than one event of type \"" + eventType.getSimpleName() + "\" is associated to element \"" + String.valueOf(element) + "\".");
        }
        return (T)(events.isEmpty() ? null : (EntityEvent)events.get(0));
    }

    public static EList<EntityEvent> getEvents(TimingSpecification ts, IModelElement element) {
        BasicEList rval = new BasicEList();
        for (Event event : ts.getEvents()) {
            if (!(event instanceof EntityEvent) || event.getEntity() != element) continue;
            rval.add((Object)((EntityEvent)event));
        }
        return rval;
    }

    public static <T extends EntityEvent> EList<T> getEvents(TimingSpecificationImpl ts, Class<T> type) {
        return EcoreUtils.pickInstanceOf(type, TimingSpecificationStaticImpl.getEvents(ts));
    }

    public static void addEvent(TimingSpecification ts, Event event) {
        if (event instanceof EntityEvent) {
            EntityEvent entityEvent = (EntityEvent)event;
            Class<?> eventType = entityEvent.getClass();
            IModelElement element = entityEvent.getReference();
            if (TimingSpecificationStaticImpl.getEvent(ts, element, eventType) != null) {
                throw new RuntimeException("An event of type \"" + eventType.getSimpleName() + "\" is associated to element \"" + String.valueOf(element) + "\" already exists.");
            }
        }
        UniqueIDUtils.prepareUniqueID((EObject)event, (EObject)ts);
        ts.getEvents().add((Object)event);
    }

    public static EList<EventChain> getEventChains(TimingSpecification ts) {
        return ts.getEventChainsContainer().getEventChains();
    }

    public static EList<EventConstraint> getConstraints(TimingSpecification ts) {
        return ts.getConstraintsContainer().getConstraints();
    }

    public static EList<EventConstraint> getConstraints(TimingSpecification ts, Event event) {
        BasicEList rval = new BasicEList();
        for (EventConstraint constraint : EcoreUtils.pickInstanceOf(EventConstraint.class, ts.getConstraints())) {
            if (!TimingSpecificationStaticImpl.isEventReference(constraint, event)) continue;
            rval.add((Object)constraint);
        }
        return rval;
    }

    private static <T extends EventReference> boolean isEventReference(T eventReference, Event event) {
        for (EReference ref : eventReference.eClass().getEAllReferences()) {
            Class refType = ref.getEReferenceType().getInstanceClass();
            boolean isEventReference = Event.class.isAssignableFrom(refType);
            if (!isEventReference) continue;
            if (eventReference.eGet((EStructuralFeature)ref) == event) {
                return true;
            }
            if (!ref.isMany()) continue;
            for (Object elem : (EList)eventReference.eGet((EStructuralFeature)ref)) {
                if (elem != event) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends EventConstraint> T getConstraint(TimingSpecification ts, Event event, Class<T> constraintType) {
        EList constraints = EcoreUtils.pickInstanceOf(constraintType, TimingSpecificationStaticImpl.getConstraints(ts, event));
        if (constraints.size() > 1) {
            throw new RuntimeException("More than one constraint of type \"" + constraintType.getSimpleName() + "\" is associated to event \"" + String.valueOf(event) + "\".");
        }
        return (T)(constraints.isEmpty() ? null : (EventConstraint)constraints.get(0));
    }

    public static EList<EventConstraint> getConstraints(TimingSpecification ts, IModelElement element) {
        HashSet<EventConstraint> constraints = new HashSet<EventConstraint>();
        for (EntityEvent event : TimingSpecificationStaticImpl.getEvents(ts, element)) {
            constraints.addAll((Collection<EventConstraint>)TimingSpecificationStaticImpl.getConstraints(ts, event));
        }
        return new BasicEList(constraints);
    }

    public static <C extends EventConstraint, E extends Event> C getConstraint(TimingSpecification ts, IModelElement element, Class<C> constraintType, Class<E> eventType) {
        EList constraints = EcoreUtils.pickInstanceOf(constraintType, TimingSpecificationStaticImpl.getConstraints(ts, element));
        if (constraints.size() > 1) {
            throw new RuntimeException("More than one constraint of type \"" + constraintType.getSimpleName() + "\" is associated to element \"" + String.valueOf(element) + "\".");
        }
        return (C)(constraints.isEmpty() ? null : (EventConstraint)constraints.get(0));
    }

    public static EList<EventChain> getEventChains(TimingSpecification ts, Event event) {
        BasicEList rval = new BasicEList();
        for (EventChain constraint : EcoreUtils.getChildrenWithType((EObject)ts.getEventChainsContainer(), EventChain.class)) {
            if (!TimingSpecificationStaticImpl.isEventReference(constraint, event)) continue;
            rval.add((Object)constraint);
        }
        return rval;
    }
}

