/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.timing.utils;

import java.math.BigDecimal;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.af3.timing.model.AF3TimingFactory;
import org.fortiss.af3.timing.model.AperiodicConstraint;
import org.fortiss.af3.timing.model.EntityEvent;
import org.fortiss.af3.timing.model.EventChain;
import org.fortiss.af3.timing.model.PeriodicConstraint;
import org.fortiss.af3.timing.model.ReactionConstraint;
import org.fortiss.af3.timing.model.SporadicConstraint;
import org.fortiss.af3.timing.model.SynchronizationConstraint;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class TimingModelElementFactory {
    public static TimingSpecification createTimingSpecification(String name) {
        AF3TimingFactory factory = AF3TimingFactory.eINSTANCE;
        TimingSpecification ts = factory.createTimingSpecification();
        ts.setName(name);
        ts.setEventsContainer(factory.createEventsContainer());
        ts.setEventChainsContainer(factory.createEventChainsContainer());
        ts.setConstraintsContainer(factory.createEventConstraintsContainer());
        return ts;
    }

    public static TimingSpecification createTimingSpecification(String name, IProjectRootElement rootElement) {
        TimingSpecification ts = TimingModelElementFactory.createTimingSpecification(name);
        ts.getRootElements().add((Object)rootElement);
        return ts;
    }

    public static EventChain createEventChain() {
        return AF3TimingFactory.eINSTANCE.createEventChain();
    }

    public static <T extends EntityEvent> T createEntityEvent(Class<T> eventType, IModelElement element) {
        EClass eventTypeEClass = EcoreUtils.getEClassForClass(eventType);
        EntityEvent event = (EntityEvent)EcoreUtil.create((EClass)eventTypeEClass);
        event.setReference(element);
        return (T)event;
    }

    public static PeriodicConstraint createPeriodicConstraint() {
        PeriodicConstraint pConstr = AF3TimingFactory.eINSTANCE.createPeriodicConstraint();
        pConstr.setJitter(BigDecimal.ZERO);
        return pConstr;
    }

    public static AperiodicConstraint createAperiodicConstraint() {
        return AF3TimingFactory.eINSTANCE.createAperiodicConstraint();
    }

    public static SporadicConstraint createSporadicConstraint() {
        return AF3TimingFactory.eINSTANCE.createSporadicConstraint();
    }

    public static SynchronizationConstraint createSynchronizationConstraint() {
        return AF3TimingFactory.eINSTANCE.createSynchronizationConstraint();
    }

    public static ReactionConstraint createReactionContraint() {
        return AF3TimingFactory.eINSTANCE.createReactionConstraint();
    }
}

