/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.timing.utils;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.timing.AF3TimingActivator;
import org.fortiss.af3.timing.approximation.ComponentExecutionTimeApproximation;
import org.fortiss.af3.timing.model.AF3TimingFactory;
import org.fortiss.af3.timing.model.EntityEvent;
import org.fortiss.af3.timing.model.Event;
import org.fortiss.af3.timing.model.EventChain;
import org.fortiss.af3.timing.model.EventReference;
import org.fortiss.af3.timing.model.PeriodicConstraint;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.af3.timing.utils.TimingModelElementFactory;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class TimingUtils {
    public static Integer calculateApproxWcet(Component component) {
        ComponentExecutionTimeApproximation approx = new ComponentExecutionTimeApproximation(component);
        Integer approxWCET = null;
        try {
            approxWCET = approx.computeApproximation().getWCETApproximation();
        }
        catch (TransformationFailedException e) {
            String compName = KernelModelElementUtils.computeFullyQualifiedName((INamedElement)component);
            LoggingUtils.error((Plugin)AF3TimingActivator.getDefault(), (String)("Failed to determine approximate WCET for component " + compName), (Throwable)e);
        }
        return approxWCET;
    }

    public static BigDecimal getPeriod(TimingSpecification ts, IModelElement element, Class<? extends EntityEvent> eventType) {
        PeriodicConstraint periodicConstr = ts.getConstraint(element, PeriodicConstraint.class, eventType);
        return periodicConstr != null ? periodicConstr.getPeriod() : null;
    }

    public static PeriodicConstraint setPeriod(TimingSpecification ts, IModelElement element, Class<? extends EntityEvent> eventType, BigDecimal period) {
        PeriodicConstraint periodicConstr = ts.getConstraint(element, PeriodicConstraint.class, eventType);
        if (periodicConstr == null) {
            EntityEvent event = TimingModelElementFactory.createEntityEvent(eventType, element);
            UniqueIDUtils.prepareUniqueID((EObject)event, (EObject)element);
            ts.getEvents().add((Object)event);
            periodicConstr = AF3TimingFactory.eINSTANCE.createPeriodicConstraint();
            periodicConstr.setEvent(event);
            UniqueIDUtils.prepareUniqueID((EObject)periodicConstr, (EObject)element);
            ts.getConstraints().add((Object)periodicConstr);
        }
        periodicConstr.setPeriod(period);
        periodicConstr.setJitter(BigDecimal.ZERO);
        return periodicConstr;
    }

    public static List<EventReference> getCanonicalEventReferences(TimingSpecification ts, Event event) {
        Stream constraints = ts.getConstraints(event).stream();
        Stream<EventChain> eventChains = ts.getEventChains(event).stream().filter(c -> c.getParentChain() == null || !c.isFirstSubChain() && !c.isLastSubChain());
        return Stream.concat(constraints, eventChains).collect(Collectors.toList());
    }
}

