/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.consistency;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.fortiss.tooling.ext.consistency.ConsistencyAdapterEnvironment;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AF3ConsistencyActivator
extends Plugin {
    public static final String PLUGIN_ID = AF3ConsistencyActivator.class.getPackage().getName();
    private static final String RESOURCE_DIRECTORY_PATH = "res/";
    private static final boolean AUTOMATICALLY_START_CONSISTENCY_ADAPTER_WITH_ECLIPSE = false;
    private static ConsistencyAdapterEnvironment adapterEnvironment;
    private static AF3ConsistencyActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.stopConsistencyAdapterEnvironment();
        plugin = null;
        super.stop(context);
    }

    public Job setUpAndStartConsistencyAdapterEnvironment() {
        String adapterResourceFolderPath = AF3ConsistencyActivator.getInternalAdapterResourcePath();
        return this.setUpAndStartConsistencyAdapterEnvironment(adapterResourceFolderPath);
    }

    public Job setUpAndStartConsistencyAdapterEnvironment(final String adapterResourceFolderPath) {
        adapterEnvironment = ConsistencyAdapterEnvironment.getInstance();
        Job job = new Job("Starting AF3 Consistency Adapter"){

            protected IStatus run(IProgressMonitor monitor) {
                boolean loadSuccess = adapterEnvironment.load(adapterResourceFolderPath);
                boolean startSuccess = adapterEnvironment.start();
                if (loadSuccess && startSuccess) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
        return job;
    }

    public void stopConsistencyAdapterEnvironment() {
        if (adapterEnvironment != null) {
            adapterEnvironment.stop();
        }
    }

    public static AF3ConsistencyActivator getDefault() {
        return plugin;
    }

    private static String getInternalAdapterResourcePath() {
        String path = "";
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)PLUGIN_ID), (IPath)new Path(RESOURCE_DIRECTORY_PATH), null);
        try {
            path = FileLocator.toFileURL((URL)url).getPath();
        }
        catch (Exception e) {
            System.err.println("Custom URL '" + String.valueOf(url) + "' could not be converted into normal file URL.");
        }
        if (!path.isBlank()) {
            File resourceFolder = new File(path);
            path = resourceFolder.getAbsolutePath();
        }
        return path;
    }

    public String getLastErrorMessage() {
        if (adapterEnvironment != null) {
            return adapterEnvironment.getLastErrorMessage();
        }
        return "";
    }

    public String getLastWarningMessage() {
        if (adapterEnvironment != null) {
            return adapterEnvironment.getLastWarningMessage();
        }
        return "";
    }
}

