/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.consistency;

import org.fortiss.consistency.utils.ConsistencyUtils;
import org.fortiss.tooling.ext.consistency.communication.AdapterClient;
import org.fortiss.tooling.ext.consistency.communication.AdapterDataServer;
import org.fortiss.tooling.ext.consistency.configuration.AdapterConsistencyConfiguration;

public class ConsistencyAdapterEnvironment {
    private static ConsistencyAdapterEnvironment SINGLETON_INSTANCE;
    private AdapterConsistencyConfiguration config;
    private AdapterClient consistencyAdapterClient;
    private AdapterDataServer dataServer;
    private boolean isRunning = false;
    private double loggerSetupTime = 0.0;
    private double registerTime = 0.0;
    private double clientSetupTime = 0.0;
    private double securitySetupTime = 0.0;
    private double serverSetupTime = 0.0;

    private ConsistencyAdapterEnvironment() {
        ConsistencyUtils.setUpLoggingBase();
    }

    public static synchronized ConsistencyAdapterEnvironment getInstance() {
        if (SINGLETON_INSTANCE == null) {
            SINGLETON_INSTANCE = new ConsistencyAdapterEnvironment();
        }
        return SINGLETON_INSTANCE;
    }

    public static synchronized boolean isLoaded() {
        return SINGLETON_INSTANCE != null && ConsistencyAdapterEnvironment.SINGLETON_INSTANCE.config != null && ConsistencyAdapterEnvironment.SINGLETON_INSTANCE.config.isConfigurationLoaded();
    }

    public static synchronized boolean isRunning() {
        return ConsistencyAdapterEnvironment.isLoaded() && ConsistencyAdapterEnvironment.SINGLETON_INSTANCE.isRunning;
    }

    public String getLastErrorMessage() {
        if (this.config != null) {
            return this.config.getLastErrorMessage();
        }
        return "";
    }

    public String getLastWarningMessage() {
        if (this.config != null) {
            return this.config.getLastWarningMessage();
        }
        return "";
    }

    public boolean load(String resourceFolder) {
        this.config = new AdapterConsistencyConfiguration(resourceFolder);
        this.config.logInfo("Consistency adapter environment is loading configuration ...");
        this.config.loadConfiguration();
        if (this.config.isConfigurationLoaded()) {
            this.config.logInfo("Consistency adapter environment has loaded configuration and is ready to be started.");
            return true;
        }
        this.config.logWarning("Consistency adapter environment could not (fully) load configuration and is therefore probably not ready to be started.");
        return false;
    }

    public boolean start() {
        String errorMessage;
        if (!this.config.isConfigurationLoaded()) {
            this.config.logError("Consistency adapter environment could not be started (and is therefore not active), because settings were not loaded beforehand. This error might be the cause:\n\t" + this.getLastErrorMessage());
            return false;
        }
        this.config.logInfo("Consistency adapter environment is starting.");
        long startTime = System.nanoTime();
        boolean success = true;
        String reason = "";
        try {
            String path = this.config.setupConsistencyLogger();
            if (path == null) {
                reason = "The path for the log files is null.";
                success = false;
            }
            this.config.logInfo("Consistency logger is activated and stores at: " + path);
        }
        catch (Exception e) {
            reason = e.getMessage();
            success = false;
        }
        if (!success) {
            this.config.logError("Consistency adapter environment is not active, because the logger could not be set up correctly. Reason:\n\t" + reason);
            return false;
        }
        this.loggerSetupTime = (double)(System.nanoTime() - startTime) * 1.0E-6;
        startTime = System.nanoTime();
        this.config.registerAllElements();
        this.registerTime = (double)(System.nanoTime() - startTime) * 1.0E-6;
        startTime = System.nanoTime();
        success = this.config.getEncryptionManager().performInitialSetup();
        this.securitySetupTime = (double)(System.nanoTime() - startTime) * 1.0E-6;
        if (!success) {
            errorMessage = "Consistency adapter environment is not active, because the initial security setup could not be performed successfully.";
            this.config.logError(errorMessage);
            return false;
        }
        startTime = System.nanoTime();
        this.dataServer = new AdapterDataServer();
        success = this.dataServer.start();
        if (!success) {
            errorMessage = "Consistency adapter environment is not active, because adapter data server could not be started.";
            this.config.logError(errorMessage);
            return false;
        }
        this.serverSetupTime = (double)(System.nanoTime() - startTime) * 1.0E-6;
        startTime = System.nanoTime();
        this.consistencyAdapterClient = new AdapterClient(this.config);
        this.clientSetupTime = (double)(System.nanoTime() - startTime) * 1.0E-6;
        double totalTime = this.loggerSetupTime + this.registerTime + this.securitySetupTime + this.serverSetupTime + this.clientSetupTime;
        String finishMessage = String.format("Consistency adapter environment is now active.\n\t- Elapsed time for setting up the adapter logger:\t% 10.2f ms\n\t- Elapsed time for registering the elements:\t\t% 10.2f ms\n\t- Elapsed time for setting up the adapter security:\t% 10.2f ms\n\t- Elapsed time for setting up the adapter server:\t% 10.2f ms\n\t- Elapsed time for setting up the adapter client:\t% 10.2f ms\n\t- Elapsed time for total adapter setup:\t\t       =% 10.2f ms", this.loggerSetupTime, this.registerTime, this.securitySetupTime, this.serverSetupTime, this.clientSetupTime, totalTime);
        this.config.logInfo(finishMessage + "\n");
        this.isRunning = true;
        return true;
    }

    public void stop() {
        if (this.dataServer != null) {
            this.dataServer.stop();
            this.dataServer = null;
        }
        this.consistencyAdapterClient = null;
        this.config = null;
        this.isRunning = false;
        SINGLETON_INSTANCE = null;
    }

    public AdapterConsistencyConfiguration getConfiguration() {
        return this.config;
    }

    public AdapterClient getConsistencyAdapterClient() {
        return this.consistencyAdapterClient;
    }

    public void refreshAdapterRegistration() {
        this.config.registerAllElements();
    }
}

